/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aerogear.unifiedpush.service.impl;

import java.util.List;
import java.util.Set;
import javax.ejb.Asynchronous;
import javax.ejb.Stateless;
import javax.inject.Inject;
import org.jboss.aerogear.unifiedpush.jpa.dao.InstallationDao;
import org.jboss.aerogear.unifiedpush.model.InstallationImpl;
import org.jboss.aerogear.unifiedpush.service.ClientInstallationService;

@Stateless
public class ClientInstallationServiceImpl
implements ClientInstallationService {
    @Inject
    private InstallationDao dao;

    public InstallationImpl addInstallation(InstallationImpl installation) {
        return (InstallationImpl)this.dao.create((Object)installation);
    }

    public void removeInstallations(List<InstallationImpl> installations) {
        for (InstallationImpl installation : installations) {
            this.removeInstallation(installation);
        }
    }

    public InstallationImpl updateInstallation(InstallationImpl installation) {
        return (InstallationImpl)this.dao.update((Object)installation);
    }

    public InstallationImpl updateInstallation(InstallationImpl installationToUpdate, InstallationImpl postedInstallation) {
        installationToUpdate.setCategories(postedInstallation.getCategories());
        installationToUpdate.setDeviceToken(postedInstallation.getDeviceToken());
        installationToUpdate.setAlias(postedInstallation.getAlias());
        installationToUpdate.setDeviceType(postedInstallation.getDeviceType());
        installationToUpdate.setOperatingSystem(postedInstallation.getOperatingSystem());
        installationToUpdate.setOsVersion(postedInstallation.getOsVersion());
        installationToUpdate.setSimplePushEndpoint(postedInstallation.getSimplePushEndpoint());
        installationToUpdate.setEnabled(postedInstallation.isEnabled());
        installationToUpdate.setPlatform(postedInstallation.getPlatform());
        return this.updateInstallation(installationToUpdate);
    }

    public InstallationImpl findById(String primaryKey) {
        return (InstallationImpl)this.dao.find(InstallationImpl.class, (Object)primaryKey);
    }

    public void removeInstallation(InstallationImpl installation) {
        this.dao.delete((Object)installation);
    }

    @Asynchronous
    public void removeInstallationsForVariantByDeviceTokens(String variantID, Set<String> deviceTokens) {
        List inactiveInstallations = this.dao.findInstallationsForVariantByDeviceTokens(variantID, deviceTokens);
        this.removeInstallations(inactiveInstallations);
    }

    public InstallationImpl findInstallationForVariantByDeviceToken(String variantID, String deviceToken) {
        return this.dao.findInstallationForVariantByDeviceToken(variantID, deviceToken);
    }

    public List<String> findAllDeviceTokenForVariantIDByCriteria(String variantID, List<String> categories, List<String> aliases, List<String> deviceTypes) {
        return this.dao.findAllDeviceTokenForVariantIDByCriteria(variantID, categories, aliases, deviceTypes);
    }

    public List<String> findAllSimplePushEndpointURLsForVariantIDByCriteria(String variantID, List<String> categories, List<String> aliases, List<String> deviceTypes) {
        return this.dao.findAllPushEndpointURLsForVariantIDByCriteria(variantID, categories, aliases, deviceTypes);
    }
}

