/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aerogear.unifiedpush.service.sender.impl;

import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.logging.Logger;
import javax.ejb.Asynchronous;
import javax.ejb.Stateless;
import javax.inject.Inject;
import org.jboss.aerogear.unifiedpush.api.Variant;
import org.jboss.aerogear.unifiedpush.message.sender.APNsPushNotificationSender;
import org.jboss.aerogear.unifiedpush.message.sender.GCMForChromePushNotificationSender;
import org.jboss.aerogear.unifiedpush.message.sender.GCMPushNotificationSender;
import org.jboss.aerogear.unifiedpush.message.sender.SimplePushNotificationSender;
import org.jboss.aerogear.unifiedpush.model.AndroidVariant;
import org.jboss.aerogear.unifiedpush.model.ChromePackagedAppVariant;
import org.jboss.aerogear.unifiedpush.model.PushApplication;
import org.jboss.aerogear.unifiedpush.model.SimplePushVariant;
import org.jboss.aerogear.unifiedpush.model.iOSVariant;
import org.jboss.aerogear.unifiedpush.service.ClientInstallationService;
import org.jboss.aerogear.unifiedpush.service.GenericVariantService;
import org.jboss.aerogear.unifiedpush.service.sender.SenderService;
import org.jboss.aerogear.unifiedpush.service.sender.impl.SenderServiceImpl;
import org.jboss.aerogear.unifiedpush.service.sender.message.SendCriteria;
import org.jboss.aerogear.unifiedpush.service.sender.message.UnifiedPushMessage;

@Stateless
@Asynchronous
public class SenderServiceImpl
implements SenderService {
    @Inject
    private GCMPushNotificationSender gcmSender;
    @Inject
    private APNsPushNotificationSender apnsSender;
    @Inject
    private SimplePushNotificationSender simplePushSender;
    @Inject
    private GCMForChromePushNotificationSender gcmForChromePushNotificationSender;
    @Inject
    private ClientInstallationService clientInstallationService;
    @Inject
    private GenericVariantService genericVariantService;
    private final Logger logger = Logger.getLogger(SenderServiceImpl.class.getName());

    @Asynchronous
    public void send(PushApplication pushApplication, UnifiedPushMessage message) {
        String simplePushVersionPayload;
        this.logger.info(String.format("Processing send request with '%s' payload", message));
        HashSet<iOSVariant> iOSVariants = new HashSet<iOSVariant>();
        HashSet<AndroidVariant> androidVariants = new HashSet<AndroidVariant>();
        HashSet<SimplePushVariant> simplePushVariants = new HashSet<SimplePushVariant>();
        HashSet<ChromePackagedAppVariant> chromePackagedAppVariants = new HashSet<ChromePackagedAppVariant>();
        SendCriteria criteria = message.getSendCriteria();
        List variantIDs = criteria.getVariants();
        if (variantIDs != null) {
            for (String variantID : variantIDs) {
                Variant variant = this.genericVariantService.findByVariantID(variantID);
                if (variant == null) continue;
                switch (1.$SwitchMap$org$jboss$aerogear$unifiedpush$api$VariantType[variant.getType().ordinal()]) {
                    case 1: {
                        androidVariants.add((AndroidVariant)variant);
                        break;
                    }
                    case 2: {
                        iOSVariants.add((iOSVariant)variant);
                        break;
                    }
                    case 3: {
                        simplePushVariants.add((SimplePushVariant)variant);
                        break;
                    }
                    case 4: {
                        chromePackagedAppVariants.add((ChromePackagedAppVariant)variant);
                    }
                }
            }
        } else {
            androidVariants.addAll(pushApplication.getAndroidVariants());
            iOSVariants.addAll(pushApplication.getIOSVariants());
            simplePushVariants.addAll(pushApplication.getSimplePushVariants());
            chromePackagedAppVariants.addAll(pushApplication.getChromePackagedAppVariants());
        }
        List categories = criteria.getCategories();
        List aliases = criteria.getAliases();
        List deviceTypes = criteria.getDeviceTypes();
        if (message.getData() != null) {
            for (iOSVariant iOSVariant2 : iOSVariants) {
                List tokenPerVariant = this.clientInstallationService.findAllDeviceTokenForVariantIDByCriteria(iOSVariant2.getVariantID(), categories, aliases, deviceTypes);
                this.sendToAPNs(iOSVariant2, (Collection)tokenPerVariant, message);
            }
            for (AndroidVariant androidVariant : androidVariants) {
                List androidTokenPerVariant = this.clientInstallationService.findAllDeviceTokenForVariantIDByCriteria(androidVariant.getVariantID(), categories, aliases, deviceTypes);
                this.sendToGCM(androidVariant, androidTokenPerVariant, message);
            }
            for (ChromePackagedAppVariant chromePackagedAppVariant : chromePackagedAppVariants) {
                List chromePackagedAppTokenPerVariant = this.clientInstallationService.findAllDeviceTokenForVariantIDByCriteria(chromePackagedAppVariant.getVariantID(), categories, aliases, deviceTypes);
                this.sendToGCMForChrome(chromePackagedAppVariant, chromePackagedAppTokenPerVariant, message);
            }
        }
        if ((simplePushVersionPayload = message.getSimplePush()) == null) {
            return;
        }
        for (SimplePushVariant simplePushVariant : simplePushVariants) {
            List pushEndpointURLsPerCategory = this.clientInstallationService.findAllSimplePushEndpointURLsForVariantIDByCriteria(simplePushVariant.getVariantID(), categories, aliases, deviceTypes);
            this.sentToSimplePush(pushEndpointURLsPerCategory, simplePushVersionPayload);
        }
    }

    private void sendToAPNs(iOSVariant iOSVariant2, Collection<String> tokens, UnifiedPushMessage pushMessage) {
        this.logger.fine(String.format("Sending: %s to APNs", pushMessage));
        this.apnsSender.sendPushMessage(iOSVariant2, tokens, pushMessage);
    }

    private void sendToGCM(AndroidVariant androidVariant, List<String> tokens, UnifiedPushMessage pushMessage) {
        this.logger.fine(String.format("Sending: %s to GCM", pushMessage));
        this.gcmSender.sendPushMessage(androidVariant, tokens, pushMessage);
    }

    private void sentToSimplePush(List<String> pushEndpointURLs, String payload) {
        this.logger.fine(String.format("Sending: %s to SimplePush network/server", payload));
        this.simplePushSender.sendMessage(pushEndpointURLs, payload);
    }

    private void sendToGCMForChrome(ChromePackagedAppVariant chromePackagedAppVariant, List<String> channelIDs, UnifiedPushMessage pushMessage) {
        this.logger.fine(String.format("Sending: %s to GCM For Chrome", pushMessage));
        this.gcmForChromePushNotificationSender.sendMessage(chromePackagedAppVariant, channelIDs, pushMessage);
    }
}

