/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aerogear.unifiedpush.service.sender.message;

import java.util.Map;
import org.jboss.aerogear.unifiedpush.service.sender.message.SendCriteria;

public class UnifiedPushMessage {
    private final SendCriteria criteria;
    private final String simplePush;
    private final String alert;
    private final String sound;
    private final boolean contentAvailable;
    private final int badge;
    private final int timeToLive;
    private final Map<String, Object> data;

    public UnifiedPushMessage(Map<String, Object> data) {
        this.criteria = new SendCriteria(data);
        this.data = (Map)data.remove("message");
        if (this.data != null) {
            this.alert = (String)this.data.remove("alert");
            this.sound = (String)this.data.remove("sound");
            Boolean contentValue = (Boolean)this.data.remove("content-available");
            this.contentAvailable = contentValue == null ? false : contentValue;
            Integer badgeVal = (Integer)this.data.remove("badge");
            this.badge = badgeVal == null ? -1 : badgeVal;
        } else {
            this.alert = null;
            this.sound = null;
            this.badge = -1;
            this.contentAvailable = false;
        }
        Integer timeToLiveValue = (Integer)data.remove("ttl");
        this.timeToLive = timeToLiveValue == null ? -1 : timeToLiveValue;
        this.simplePush = (String)data.remove("simple-push");
    }

    public SendCriteria getSendCriteria() {
        return this.criteria;
    }

    public String getSimplePush() {
        return this.simplePush;
    }

    public String getAlert() {
        return this.alert;
    }

    public int getTimeToLive() {
        return this.timeToLive;
    }

    public String getSound() {
        return this.sound;
    }

    public int getBadge() {
        return this.badge;
    }

    public boolean isContentAvailable() {
        return this.contentAvailable;
    }

    public Map<String, Object> getData() {
        return this.data;
    }

    public String toString() {
        return "UnifiedPushMessage [criteria=" + this.criteria + ", simplePush=" + this.simplePush + ", alert=" + this.alert + ", sound=" + this.sound + ", badge=" + this.badge + ", data=" + this.data + ", time-to-live=" + this.timeToLive + ", content-available=" + this.contentAvailable + "]";
    }
}

