/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aerogear.unifiedpush.users;

import java.util.Calendar;
import java.util.Date;
import javax.annotation.PostConstruct;
import javax.ejb.Singleton;
import javax.ejb.Startup;
import javax.inject.Inject;
import org.picketlink.idm.IdentityManager;
import org.picketlink.idm.PartitionManager;
import org.picketlink.idm.RelationshipManager;
import org.picketlink.idm.credential.Password;
import org.picketlink.idm.model.Account;
import org.picketlink.idm.model.IdentityType;
import org.picketlink.idm.model.basic.BasicModel;
import org.picketlink.idm.model.basic.Role;
import org.picketlink.idm.model.basic.User;

@Singleton
@Startup
public class PicketLinkDefaultUsers {
    @Inject
    private PartitionManager partitionManager;
    private IdentityManager identityManager;
    private RelationshipManager relationshipManager;

    @PostConstruct
    public void create() {
        User adminUser;
        this.identityManager = this.partitionManager.createIdentityManager();
        this.relationshipManager = this.partitionManager.createRelationshipManager();
        String DEFAULT_PASSWORD = "123";
        String DEFAULT_DEVELOPER = "developer";
        String DEFAULT_ADMIN = "admin";
        User developerUser = BasicModel.getUser((IdentityManager)this.identityManager, (String)"developer");
        if (developerUser == null) {
            developerUser = new User("developer");
            this.identityManager.add((IdentityType)developerUser);
            Calendar calendar = this.expirationDate();
            Password password = new Password("123".toCharArray());
            this.identityManager.updateCredential((Account)developerUser, (Object)password, new Date(), calendar.getTime());
            Role roleDeveloper = new Role("developer");
            this.identityManager.add((IdentityType)roleDeveloper);
            this.grantRoles(developerUser, roleDeveloper);
        }
        if ((adminUser = BasicModel.getUser((IdentityManager)this.identityManager, (String)"admin")) == null) {
            adminUser = new User("admin");
            this.identityManager.add((IdentityType)adminUser);
            Calendar calendar = this.expirationDate();
            Password password = new Password("123".toCharArray());
            this.identityManager.updateCredential((Account)adminUser, (Object)password, new Date(), calendar.getTime());
            Role roleAdmin = new Role("admin");
            this.identityManager.add((IdentityType)roleAdmin);
            this.grantRoles(adminUser, roleAdmin);
        }
    }

    private void grantRoles(User user, Role role) {
        BasicModel.grantRole((RelationshipManager)this.relationshipManager, (IdentityType)user, (Role)role);
    }

    private Calendar expirationDate() {
        int EXPIRATION_TIME = -5;
        Calendar expirationDate = Calendar.getInstance();
        expirationDate.add(12, EXPIRATION_TIME);
        return expirationDate;
    }
}

