/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aerogear.unifiedpush.service.impl;

import java.util.Map;
import javax.ejb.Stateless;
import javax.enterprise.inject.Instance;
import javax.inject.Inject;
import org.jboss.aerogear.unifiedpush.api.PushApplication;
import org.jboss.aerogear.unifiedpush.api.Variant;
import org.jboss.aerogear.unifiedpush.dao.PushApplicationDao;
import org.jboss.aerogear.unifiedpush.service.PushApplicationService;
import org.jboss.aerogear.unifiedpush.service.annotations.LoggedIn;

@Stateless
public class PushApplicationServiceImpl
implements PushApplicationService {
    @Inject
    private PushApplicationDao pushApplicationDao;
    @Inject
    @LoggedIn
    private Instance<String> loginName;

    @Override
    public void addPushApplication(PushApplication pushApp) {
        pushApp.setDeveloper((String)this.loginName.get());
        this.pushApplicationDao.create((Object)pushApp);
    }

    @Override
    public PushApplication findByPushApplicationID(String pushApplicationID) {
        return this.pushApplicationDao.findByPushApplicationID(pushApplicationID);
    }

    @Override
    public void addVariant(PushApplication pushApp, Variant variant) {
        pushApp.getVariants().add(variant);
        this.pushApplicationDao.update((Object)pushApp);
    }

    @Override
    public Map<String, Long> countInstallationsByType(String pushApplicationID) {
        return this.pushApplicationDao.countInstallationsByType(pushApplicationID);
    }

    @Override
    public void updatePushApplication(PushApplication pushApp) {
        this.pushApplicationDao.update((Object)pushApp);
    }

    @Override
    public void removePushApplication(PushApplication pushApp) {
        this.pushApplicationDao.delete((Object)pushApp);
    }
}

