/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aerogear.unifiedpush.service.metrics;

import java.util.Date;
import javax.ejb.Stateless;
import javax.inject.Inject;
import org.jboss.aerogear.unifiedpush.api.PushMessageInformation;
import org.jboss.aerogear.unifiedpush.api.VariantMetricInformation;
import org.jboss.aerogear.unifiedpush.dao.PageResult;
import org.jboss.aerogear.unifiedpush.dao.PushMessageInformationDao;
import org.jboss.aerogear.unifiedpush.dao.VariantMetricInformationDao;
import org.jboss.aerogear.unifiedpush.dto.MessageMetrics;
import org.jboss.aerogear.unifiedpush.system.ConfigurationUtils;
import org.jboss.aerogear.unifiedpush.utils.DateUtils;

@Stateless
public class PushMessageMetricsService {
    public static final String AEROGEAR_METRICS_STORAGE_MAX_DAYS = "aerogear.metrics.storage.days";
    @Inject
    private PushMessageInformationDao pushMessageInformationDao;
    @Inject
    private VariantMetricInformationDao variantMetricInformationDao;

    public PushMessageInformation storeNewRequestFrom(String pushAppId, String json, String ipAddress, String clientIdentifier, int totalVariantCount) {
        PushMessageInformation information = new PushMessageInformation();
        information.setRawJsonMessage(json);
        information.setIpAddress(ipAddress);
        information.setPushApplicationId(pushAppId);
        information.setClientIdentifier(clientIdentifier);
        information.setServedVariants(Integer.valueOf(0));
        information.setTotalVariants(Integer.valueOf(totalVariantCount));
        this.pushMessageInformationDao.create((Object)information);
        this.pushMessageInformationDao.flushAndClear();
        return information;
    }

    public void updatePushMessageInformation(PushMessageInformation pushMessageInformation) {
        this.pushMessageInformationDao.update((Object)pushMessageInformation);
    }

    public void lock(PushMessageInformation pushMessageInformation) {
        this.pushMessageInformationDao.lock((Object)pushMessageInformation);
    }

    public PageResult<PushMessageInformation, MessageMetrics> findAllForPushApplication(String pushApplicationID, String search, boolean sorting, Integer page, Integer pageSize) {
        return this.pushMessageInformationDao.findAllForPushApplication(pushApplicationID, search, sorting, page, pageSize);
    }

    public long countMessagesForPushApplication(String pushApplicationId) {
        return this.pushMessageInformationDao.getNumberOfPushMessagesForPushApplication(pushApplicationId);
    }

    public long countMessagesForVariant(String variantID) {
        return this.pushMessageInformationDao.getNumberOfPushMessagesForVariant(variantID);
    }

    public void deleteOutdatedPushInformationData() {
        Date historyDate = DateUtils.calculatePastDate((int)ConfigurationUtils.tryGetIntegerProperty((String)AEROGEAR_METRICS_STORAGE_MAX_DAYS, (Integer)30));
        this.pushMessageInformationDao.deletePushInformationOlderThan(historyDate);
    }

    public PushMessageInformation getPushMessageInformation(String id) {
        return (PushMessageInformation)this.pushMessageInformationDao.find((Object)id);
    }

    public void updateAnalytics(String aerogearPushId, String variantID) {
        PushMessageInformation pushMessageInformation = this.getPushMessageInformation(aerogearPushId);
        if (pushMessageInformation != null) {
            if (pushMessageInformation.getFirstOpenDate() != null) {
                pushMessageInformation.setLastOpenDate(new Date());
            } else {
                pushMessageInformation.setFirstOpenDate(new Date());
                pushMessageInformation.setLastOpenDate(new Date());
            }
            pushMessageInformation.incrementAppOpenCounter();
            VariantMetricInformation variantMetricInformation = this.variantMetricInformationDao.findVariantMetricInformationByVariantID(variantID, pushMessageInformation.getId());
            variantMetricInformation.incrementVariantOpenCounter();
            this.variantMetricInformationDao.update((Object)variantMetricInformation);
            this.updatePushMessageInformation(pushMessageInformation);
        }
    }
}

