/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aerogear.unifiedpush.service.impl;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.inject.Inject;
import org.jboss.aerogear.unifiedpush.api.Installation;
import org.jboss.aerogear.unifiedpush.api.PushApplication;
import org.jboss.aerogear.unifiedpush.api.PushMessageInformation;
import org.jboss.aerogear.unifiedpush.api.Variant;
import org.jboss.aerogear.unifiedpush.dao.InstallationDao;
import org.jboss.aerogear.unifiedpush.dao.PageResult;
import org.jboss.aerogear.unifiedpush.dao.PushApplicationDao;
import org.jboss.aerogear.unifiedpush.dao.PushMessageInformationDao;
import org.jboss.aerogear.unifiedpush.dao.VariantDao;
import org.jboss.aerogear.unifiedpush.dto.Count;
import org.jboss.aerogear.unifiedpush.service.PushSearchService;
import org.jboss.aerogear.unifiedpush.service.dashboard.Application;
import org.jboss.aerogear.unifiedpush.service.dashboard.ApplicationVariant;
import org.jboss.aerogear.unifiedpush.service.dashboard.DashboardData;

public class PushSearchServiceImpl
implements PushSearchService {
    @Inject
    private PushApplicationDao pushApplicationDao;
    @Inject
    private VariantDao variantDao;
    @Inject
    private InstallationDao installationDao;
    @Inject
    private PushMessageInformationDao pushMessageInformationDao;

    @Override
    public PageResult<PushApplication, Count> findAllPushApplicationsForDeveloper(Integer page, Integer pageSize) {
        return this.pushApplicationDao.findAll(page, pageSize);
    }

    @Override
    public PushApplication findByPushApplicationIDForDeveloper(String pushApplicationID) {
        return this.pushApplicationDao.findAllByPushApplicationID(pushApplicationID);
    }

    @Override
    public boolean existsVariantIDForDeveloper(String variantID) {
        return this.variantDao.existsVariantIDForAdmin(variantID);
    }

    @Override
    public PageResult<Installation, Count> findAllInstallationsByVariantForDeveloper(String variantID, Integer page, Integer pageSize, String search) {
        return this.installationDao.findInstallationsByVariant(variantID, page, pageSize, search);
    }

    @Override
    public DashboardData loadDashboardData() {
        long totalApps = this.totalApplicationNumber();
        long totalDevices = this.totalDeviceNumber();
        long totalMessages = this.totalMessages();
        DashboardData data = new DashboardData();
        data.setApplications(totalApps);
        data.setDevices(totalDevices);
        data.setMessages(totalMessages);
        return data;
    }

    @Override
    public List<ApplicationVariant> getVariantsWithWarnings() {
        List warningIDs = this.pushMessageInformationDao.findVariantIDsWithWarnings();
        if (warningIDs.isEmpty()) {
            return Collections.emptyList();
        }
        return this.wrapApplicationVariant(this.pushApplicationDao.findByVariantIds(warningIDs));
    }

    @Override
    public List<Application> getLatestActivity(int maxResults) {
        return this.wrapApplication(this.pushMessageInformationDao.findLatestActivity(maxResults));
    }

    private long totalMessages() {
        return this.pushMessageInformationDao.getNumberOfPushMessagesForApplications();
    }

    private long totalDeviceNumber() {
        return this.installationDao.getTotalNumberOfDevices();
    }

    private long totalApplicationNumber() {
        return this.pushApplicationDao.getNumberOfPushApplicationsForDeveloper();
    }

    private List<ApplicationVariant> wrapApplicationVariant(List<PushApplication> applications) {
        ArrayList<ApplicationVariant> applicationVariants = new ArrayList<ApplicationVariant>(applications.size());
        applications.forEach(application -> application.getVariants().forEach(variant -> {
            ApplicationVariant applicationVariant = new ApplicationVariant((PushApplication)application, (Variant)variant);
            applicationVariants.add(applicationVariant);
        }));
        return applicationVariants;
    }

    private List<Application> wrapApplication(List<PushMessageInformation> pushMessageInformations) {
        ArrayList<Application> applications = new ArrayList<Application>(pushMessageInformations.size());
        pushMessageInformations.forEach(pushMessageInformation -> {
            PushApplication pushApplication = this.pushApplicationDao.findByPushApplicationID(pushMessageInformation.getPushApplicationId());
            if (pushApplication != null) {
                String applicationName = pushApplication.getName();
                Application application = new Application(applicationName, pushMessageInformation.getPushApplicationId(), pushMessageInformation.getTotalReceivers(), pushMessageInformation.getSubmitDate());
                applications.add(application);
            }
        });
        return applications;
    }
}

