/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aerogear.windows.mpns.internal;

import java.util.Collection;
import java.util.Map;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.entity.ByteArrayEntity;
import org.jboss.aerogear.windows.mpns.MpnsNotification;
import org.jboss.aerogear.windows.mpns.MpnsService;
import org.jboss.aerogear.windows.mpns.exceptions.NetworkIOException;
import org.jboss.aerogear.windows.mpns.internal.Utilities;

public abstract class AbstractMpnsService
implements MpnsService {
    protected HttpPost postMessage(String subscriptionUri, byte[] requestBody, Collection<? extends Map.Entry<String, String>> headers) {
        HttpPost method = new HttpPost(subscriptionUri);
        method.setEntity((HttpEntity)new ByteArrayEntity(requestBody));
        for (Map.Entry<String, String> entry : headers) {
            method.addHeader(entry.getKey(), entry.getValue());
        }
        return method;
    }

    protected abstract void push(HttpPost var1, MpnsNotification var2);

    @Override
    public void push(String subscriptionUri, String payload, Collection<? extends Map.Entry<String, String>> headers) throws NetworkIOException {
        this.push(this.postMessage(subscriptionUri, Utilities.toUTF8(payload), headers), null);
    }

    @Override
    public void push(String subscriptionUri, MpnsNotification message) throws NetworkIOException {
        this.push(this.postMessage(subscriptionUri, message.getRequestBody(), message.getHttpHeaders()), message);
    }

    @Override
    public void start() {
    }

    @Override
    public void stop() {
    }
}

