/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aerogear.windows.mpns.internal;

import java.io.IOException;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.util.EntityUtils;
import org.jboss.aerogear.windows.mpns.MpnsDelegate;
import org.jboss.aerogear.windows.mpns.MpnsNotification;
import org.jboss.aerogear.windows.mpns.MpnsService;
import org.jboss.aerogear.windows.mpns.exceptions.NetworkIOException;
import org.jboss.aerogear.windows.mpns.internal.AbstractMpnsService;
import org.jboss.aerogear.windows.mpns.internal.Utilities;

public class MpnsServiceImpl
extends AbstractMpnsService
implements MpnsService {
    private final HttpClient httpClient;
    private final MpnsDelegate delegate;

    public MpnsServiceImpl(HttpClient httpClient, MpnsDelegate delegate) {
        this.httpClient = httpClient;
        this.delegate = delegate;
    }

    @Override
    protected void push(HttpPost request, MpnsNotification message) {
        try {
            HttpResponse response = this.httpClient.execute((HttpUriRequest)request);
            Utilities.fireDelegate(request, message, response, this.delegate);
            EntityUtils.consume((HttpEntity)response.getEntity());
        }
        catch (ClientProtocolException e) {
            throw new RuntimeException(e);
        }
        catch (IOException e) {
            throw new NetworkIOException(e);
        }
    }

    @Override
    public void stop() {
        this.httpClient.getConnectionManager().shutdown();
    }
}

