/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aerogear.windows.mpns.notifications;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.jboss.aerogear.windows.mpns.DeliveryClass;
import org.jboss.aerogear.windows.mpns.MpnsNotification;
import org.jboss.aerogear.windows.mpns.internal.Utilities;
import org.jboss.aerogear.windows.mpns.notifications.AbstractNotificationBuilder;

public class FlipTileNotification
implements MpnsNotification {
    private final Builder builder;
    private final List<? extends Map.Entry<String, String>> headers;

    public FlipTileNotification(Builder builder, List<? extends Map.Entry<String, String>> headers) {
        this.builder = builder;
        this.headers = headers;
    }

    @Override
    public byte[] getRequestBody() {
        return this.builder.toByteArray();
    }

    @Override
    public List<? extends Map.Entry<String, String>> getHttpHeaders() {
        return Collections.unmodifiableList(this.headers);
    }

    public static class Builder
    extends AbstractNotificationBuilder<Builder, FlipTileNotification> {
        private String backgroundImage;
        private String title;
        private String backBackgroundImage;
        private String backTitle;
        private String backContent;
        private int count;
        private String smallBackgroundImage;
        private String wideBackgroundImage;
        private String wideBackBackgroundImage;
        private String wideBackContent;
        private String tileId;
        private boolean isClear;

        public Builder() {
            super("token");
            this.contentType("text/xml");
        }

        public Builder tileId(String tileId) {
            this.tileId = tileId;
            return this;
        }

        public Builder isClear(boolean clear) {
            this.isClear = clear;
            return this;
        }

        public Builder backgroundImage(String backgroundImage) {
            this.backgroundImage = backgroundImage;
            return this;
        }

        public Builder title(String title) {
            this.title = title;
            return this;
        }

        public Builder backBackgroundImage(String backBackgroundImage) {
            this.backBackgroundImage = backBackgroundImage;
            return this;
        }

        public Builder backTitle(String backTitle) {
            this.backTitle = backTitle;
            return this;
        }

        public Builder backContent(String backContent) {
            this.backContent = backContent;
            return this;
        }

        public Builder count(int count) {
            this.count = count;
            return this;
        }

        public Builder smallBackgroundImage(String smallBackgroundImage) {
            this.smallBackgroundImage = smallBackgroundImage;
            return this;
        }

        public Builder wideBackgroundImage(String wideBackgroundImage) {
            this.wideBackgroundImage = wideBackgroundImage;
            return this;
        }

        public Builder wideBackBackgroundImage(String wideBackBackgroundImage) {
            this.wideBackBackgroundImage = wideBackBackgroundImage;
            return this;
        }

        public Builder wideBackContent(String wideBackContent) {
            this.wideBackContent = wideBackContent;
            return this;
        }

        @Override
        protected int deliveryValueOf(DeliveryClass delivery) {
            return Utilities.getTileDelivery(delivery);
        }

        @Override
        public FlipTileNotification build() {
            return new FlipTileNotification(this, this.headers);
        }

        public byte[] toByteArray() {
            StringBuilder sb = new StringBuilder();
            sb.append("<?xml version=\"1.0\" encoding=\"utf-8\"?>");
            sb.append("<wp:Notification xmlns:wp=\"WPNotification\">");
            sb.append("<wp:Tile");
            if (this.tileId != null) {
                sb.append(" Id=\"");
                sb.append(this.tileId);
                sb.append("\"");
            }
            sb.append(" Template=\"FlipTile\">");
            if (this.isClear) {
                sb.append(Utilities.xmlElementClear("SmallBackgroundImage", this.smallBackgroundImage));
            } else {
                sb.append(Utilities.xmlElement("SmallBackgroundImage", this.smallBackgroundImage));
            }
            sb.append(Utilities.xmlElementClear("WideBackgroundImage", this.wideBackgroundImage));
            sb.append(Utilities.xmlElementClear("WideBackBackgroundImage", this.wideBackBackgroundImage));
            sb.append(Utilities.xmlElementClear("WideBackContent", this.wideBackContent));
            sb.append(Utilities.xmlElementClear("BackgroundImage", this.backgroundImage));
            sb.append(Utilities.xmlElementClear("Count", "" + this.count));
            sb.append(Utilities.xmlElementClear("Title", this.title));
            sb.append(Utilities.xmlElementClear("BackBackgroundImage", this.backBackgroundImage));
            sb.append(Utilities.xmlElementClear("BackTitle", this.backTitle));
            sb.append(Utilities.xmlElementClear("BackContent", this.backContent));
            sb.append("</wp:Tile>");
            sb.append("</wp:Notification>");
            return Utilities.toUTF8(sb.toString());
        }
    }
}

