/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.amqp_1_0.codec;

import java.io.IOException;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.qpid.amqp_1_0.codec.DescribedType;
import org.apache.qpid.amqp_1_0.codec.DescribedTypeConstructor;

public class DefaultDescribedTypeConstructor
extends DescribedTypeConstructor {
    private Object _descriptor;

    public DefaultDescribedTypeConstructor(Object descriptor) {
        this._descriptor = descriptor;
    }

    public Object construct(Object underlying) {
        return new DescribedType(this._descriptor, underlying);
    }

    public static void main(String[] args) throws IOException, ParseException {
        String line;
        LineNumberReader reader = new LineNumberReader(new InputStreamReader(System.in));
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss,SSS");
        Pattern pattern = Pattern.compile("^\\d+ (\\d{4}-\\d{2}-\\d{2} \\d\\d:\\d\\d:\\d\\d,\\d\\d\\d)");
        long prevTime = Long.MAX_VALUE;
        while ((line = reader.readLine()) != null) {
            Matcher m = pattern.matcher(line);
            if (!m.matches()) continue;
            String timeStr = m.group(1);
            long time = df.parse(timeStr).getTime();
            if (time - prevTime > 20000L) {
                System.out.println(df.format(prevTime) + " - " + df.format(time));
            }
            prevTime = time;
        }
    }
}

