/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.amqp_1_0.codec;

import java.nio.ByteBuffer;
import org.apache.qpid.amqp_1_0.codec.TypeConstructor;
import org.apache.qpid.amqp_1_0.codec.ValueHandler;
import org.apache.qpid.amqp_1_0.type.AmqpErrorException;
import org.apache.qpid.amqp_1_0.type.transport.ConnectionError;
import org.apache.qpid.amqp_1_0.type.transport.Error;

public class ShortTypeConstructor
implements TypeConstructor {
    private static final ShortTypeConstructor INSTANCE = new ShortTypeConstructor();

    public static ShortTypeConstructor getInstance() {
        return INSTANCE;
    }

    private ShortTypeConstructor() {
    }

    public Object construct(ByteBuffer in, ValueHandler handler) throws AmqpErrorException {
        if (in.remaining() >= 2) {
            return in.getShort();
        }
        Error error = new Error();
        error.setCondition(ConnectionError.FRAMING_ERROR);
        error.setDescription("Cannot construct short: insufficient input data");
        throw new AmqpErrorException(error);
    }
}

