/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.amqp_1_0.transport;

import java.nio.ByteBuffer;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import org.apache.qpid.amqp_1_0.codec.ValueWriter;
import org.apache.qpid.amqp_1_0.framing.AMQFrame;
import org.apache.qpid.amqp_1_0.transport.ConnectionEndpoint;
import org.apache.qpid.amqp_1_0.transport.FrameOutputHandler;
import org.apache.qpid.amqp_1_0.transport.FrameTransport;
import org.apache.qpid.amqp_1_0.transport.StateChangeListener;
import org.apache.qpid.amqp_1_0.type.FrameBody;

public class AMQPFrameTransport
implements FrameTransport<AMQFrame<FrameBody>>,
FrameOutputHandler<FrameBody> {
    private final Object _inputLock = new Object();
    private final Object _outputLock = new Object();
    private volatile boolean _inputOpen = true;
    private volatile boolean _outputOpen = true;
    private final ConnectionEndpoint _endpoint;
    private final BlockingQueue<AMQFrame<FrameBody>> _queue = new ArrayBlockingQueue<AMQFrame<FrameBody>>(100);
    private StateChangeListener _inputListener;
    private StateChangeListener _outputListener;

    public AMQPFrameTransport(ConnectionEndpoint endpoint) {
        this._endpoint = endpoint;
        this._endpoint.setFrameOutputHandler(this);
    }

    @Override
    public boolean isOpenForInput() {
        return this._inputOpen;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void closeForInput() {
        Object object = this._inputLock;
        synchronized (object) {
            this._inputOpen = false;
            this._inputLock.notifyAll();
        }
    }

    @Override
    public void processIncomingFrame(AMQFrame<FrameBody> frame) {
        frame.getFrameBody().invoke(frame.getChannel(), this._endpoint);
    }

    @Override
    public boolean canSend() {
        return this._queue.remainingCapacity() != 0;
    }

    @Override
    public void send(AMQFrame<FrameBody> frame) {
        this.send(frame, (ByteBuffer)null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void send(AMQFrame<FrameBody> frame, ByteBuffer payload) {
        Object object = this._endpoint.getLock();
        synchronized (object) {
            boolean empty = this._queue.isEmpty();
            try {
                while (!this._queue.offer(frame)) {
                    this._endpoint.getLock().wait(1000L);
                }
                if (empty && this._outputListener != null) {
                    this._outputListener.onStateChange(true);
                }
                this._endpoint.getLock().notifyAll();
            }
            catch (InterruptedException e) {
                // empty catch block
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        Object object = this._endpoint.getLock();
        synchronized (object) {
            this._endpoint.getLock().notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public AMQFrame<FrameBody> getNextFrame() {
        Object object = this._endpoint.getLock();
        synchronized (object) {
            AMQFrame frame = null;
            if (this.isOpenForOutput()) {
                frame = (AMQFrame)this._queue.poll();
            }
            return frame;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void closeForOutput() {
        Object object = this._outputLock;
        synchronized (object) {
            this._outputOpen = false;
            this._outputLock.notifyAll();
        }
    }

    @Override
    public boolean isOpenForOutput() {
        return this._outputOpen;
    }

    public ValueWriter.Registry getRegistry() {
        return this._endpoint.getDescribedTypeRegistry();
    }

    @Override
    public void setInputStateChangeListener(StateChangeListener listener) {
        this._inputListener = listener;
    }

    @Override
    public void setOutputStateChangeListener(StateChangeListener listener) {
        this._outputListener = listener;
    }

    public void setVersion(byte major, byte minor, byte revision) {
    }

    public byte getMajorVersion() {
        return this._endpoint.getMajorVersion();
    }

    public byte getMinorVersion() {
        return this._endpoint.getMinorVersion();
    }

    public byte getRevision() {
        return this._endpoint.getRevision();
    }
}

