/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.amqp_1_0.jms.impl;

import java.util.Map;
import javax.jms.InvalidSelectorException;
import javax.jms.JMSException;
import org.apache.qpid.amqp_1_0.client.AcknowledgeMode;
import org.apache.qpid.amqp_1_0.client.ConnectionErrorException;
import org.apache.qpid.amqp_1_0.client.Receiver;
import org.apache.qpid.amqp_1_0.jms.Topic;
import org.apache.qpid.amqp_1_0.jms.TopicSubscriber;
import org.apache.qpid.amqp_1_0.jms.impl.MessageConsumerImpl;
import org.apache.qpid.amqp_1_0.jms.impl.SessionImpl;
import org.apache.qpid.amqp_1_0.jms.impl.TopicImpl;
import org.apache.qpid.amqp_1_0.type.DistributionMode;
import org.apache.qpid.amqp_1_0.type.Symbol;
import org.apache.qpid.amqp_1_0.type.messaging.Filter;
import org.apache.qpid.amqp_1_0.type.messaging.StdDistMode;
import org.apache.qpid.amqp_1_0.type.transport.AmqpError;
import org.apache.qpid.amqp_1_0.type.transport.Error;

public class TopicSubscriberImpl
extends MessageConsumerImpl
implements TopicSubscriber {
    TopicSubscriberImpl(String name, boolean durable, Topic destination, SessionImpl session, String selector, boolean noLocal) throws JMSException {
        super(destination, session, selector, noLocal, name, durable);
        this.setTopicSubscriber(true);
    }

    TopicSubscriberImpl(Topic destination, SessionImpl session, String selector, boolean noLocal) throws JMSException {
        super(destination, session, selector, noLocal);
        this.setTopicSubscriber(true);
    }

    @Override
    public TopicImpl getTopic() throws JMSException {
        return (TopicImpl)this.getDestination();
    }

    @Override
    protected Receiver createClientReceiver() throws JMSException {
        try {
            String address = this.getSession().toAddress(this.getDestination());
            Receiver receiver = this.getSession().getClientSession().createReceiver(address, (DistributionMode)StdDistMode.COPY, AcknowledgeMode.ALO, this.getLinkName(), this.isDurable(), this.getFilters(), null);
            String actualAddress = receiver.getAddress();
            Map actualFilters = receiver.getFilter();
            if (!address.equals(actualAddress) || !this.filtersEqual(this.getFilters(), actualFilters)) {
                receiver.close();
                if (this.isDurable()) {
                    receiver = this.getSession().getClientSession().createReceiver(address, (DistributionMode)StdDistMode.COPY, AcknowledgeMode.ALO, this.getLinkName(), false, this.getFilters(), null);
                    receiver.close();
                }
                receiver = this.getSession().getClientSession().createReceiver(address, (DistributionMode)StdDistMode.COPY, AcknowledgeMode.ALO, this.getLinkName(), this.isDurable(), this.getFilters(), null);
            }
            return receiver;
        }
        catch (ConnectionErrorException e) {
            Error error = e.getRemoteError();
            if (AmqpError.INVALID_FIELD.equals(error.getCondition())) {
                throw new InvalidSelectorException(e.getMessage());
            }
            throw new JMSException(e.getMessage(), error.getCondition().getValue().toString());
        }
    }

    private boolean filtersEqual(Map<Symbol, Filter> filters, Map<Symbol, Filter> actualFilters) {
        if (filters == null || filters.isEmpty()) {
            return actualFilters == null || actualFilters.isEmpty();
        }
        return actualFilters != null && filters.equals(actualFilters);
    }

    @Override
    protected void closeUnderlyingReceiver(Receiver receiver) {
        receiver.close();
    }
}

