/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.amqp_1_0.codec;

import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.qpid.amqp_1_0.codec.BinaryString;
import org.apache.qpid.amqp_1_0.codec.ValueHandler;
import org.apache.qpid.amqp_1_0.codec.VariableWidthTypeConstructor;
import org.apache.qpid.amqp_1_0.type.AmqpErrorException;
import org.apache.qpid.amqp_1_0.type.Symbol;

public class SymbolTypeConstructor
extends VariableWidthTypeConstructor {
    private static final Charset ASCII = Charset.forName("US-ASCII");
    private static final ConcurrentHashMap<BinaryString, Symbol> SYMBOL_MAP = new ConcurrentHashMap(2048);

    public static SymbolTypeConstructor getInstance(int i) {
        return new SymbolTypeConstructor(i);
    }

    private SymbolTypeConstructor(int size) {
        super(size);
    }

    @Override
    public Object construct(ByteBuffer in, boolean isCopy, ValueHandler handler) throws AmqpErrorException {
        int size = this.getSize() == 1 ? in.get() & 0xFF : in.getInt();
        BinaryString binaryStr = new BinaryString(in.array(), in.arrayOffset() + in.position(), size);
        Symbol symbolVal = SYMBOL_MAP.get(binaryStr);
        if (symbolVal == null) {
            ByteBuffer dup = in.duplicate();
            try {
                dup.limit(in.position() + size);
            }
            catch (IllegalArgumentException e) {
                System.err.println("in.position(): " + in.position());
                System.err.println("size: " + size);
                System.err.println("dup.position(): " + dup.position());
                System.err.println("dup.capacity(): " + dup.capacity());
                System.err.println("dup.limit(): " + dup.limit());
                throw e;
            }
            CharBuffer charBuf = ASCII.decode(dup);
            symbolVal = Symbol.getSymbol(charBuf.toString());
            byte[] data = new byte[size];
            in.get(data);
            binaryStr = new BinaryString(data, 0, size);
            SYMBOL_MAP.putIfAbsent(binaryStr, symbolVal);
        } else {
            in.position(in.position() + size);
        }
        return symbolVal;
    }
}

