/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.amqp_1_0.client;

import org.apache.qpid.amqp_1_0.client.Session;
import org.apache.qpid.amqp_1_0.client.Transaction;
import org.apache.qpid.amqp_1_0.messaging.SectionEncoder;
import org.apache.qpid.amqp_1_0.transport.DeliveryStateHandler;
import org.apache.qpid.amqp_1_0.transport.SendingLinkEndpoint;
import org.apache.qpid.amqp_1_0.type.Binary;
import org.apache.qpid.amqp_1_0.type.DeliveryState;
import org.apache.qpid.amqp_1_0.type.messaging.AmqpValue;
import org.apache.qpid.amqp_1_0.type.transaction.Declare;
import org.apache.qpid.amqp_1_0.type.transaction.Declared;
import org.apache.qpid.amqp_1_0.type.transaction.Discharge;
import org.apache.qpid.amqp_1_0.type.transport.Transfer;

public class TransactionController
implements DeliveryStateHandler {
    private static final Binary DELIVERY_TAG = new Binary(new byte[]{0});
    private SendingLinkEndpoint _endpoint;
    private Session _session;
    private volatile DeliveryState _state;
    private boolean _received;

    public TransactionController(Session session, SendingLinkEndpoint tcLinkEndpoint) {
        this._session = session;
        this._endpoint = tcLinkEndpoint;
        this._endpoint.setDeliveryStateHandler((DeliveryStateHandler)this);
    }

    public Transaction beginTransaction() {
        Binary txnId = this.declare();
        return new Transaction(this, txnId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Binary declare() {
        Object lock;
        SectionEncoder encoder = this._session.getSectionEncoder();
        AmqpValue section = new AmqpValue((Object)new Declare());
        Transfer transfer = new Transfer();
        transfer.setPayload(section.encode(encoder).asByteBuffer());
        transfer.setDeliveryTag(DELIVERY_TAG);
        transfer.setSettled(Boolean.FALSE);
        Object object = lock = this._endpoint.getLock();
        synchronized (object) {
            while (!this._endpoint.hasCreditToSend()) {
                try {
                    lock.wait();
                }
                catch (InterruptedException e) {}
            }
            this._state = null;
            this._received = false;
            this._endpoint.transfer(transfer);
        }
        object = this;
        synchronized (object) {
            while (!this._received) {
                try {
                    this.wait();
                }
                catch (InterruptedException e) {}
            }
        }
        return ((Declared)this._state).getTxnId();
    }

    public void commit(Transaction transaction) {
        this.discharge(transaction.getTxnId(), false);
    }

    public void rollback(Transaction transaction) {
        this.discharge(transaction.getTxnId(), true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void discharge(Binary txnId, boolean fail) {
        Object lock;
        Discharge discharge = new Discharge();
        discharge.setTxnId(txnId);
        discharge.setFail(Boolean.valueOf(fail));
        SectionEncoder encoder = this._session.getSectionEncoder();
        AmqpValue section = new AmqpValue((Object)discharge);
        Transfer transfer = new Transfer();
        transfer.setPayload(section.encode(encoder).asByteBuffer());
        transfer.setDeliveryTag(DELIVERY_TAG);
        transfer.setSettled(Boolean.FALSE);
        Object object = lock = this._endpoint.getLock();
        synchronized (object) {
            while (!this._endpoint.hasCreditToSend()) {
                try {
                    lock.wait();
                }
                catch (InterruptedException e) {}
            }
            this._state = null;
            this._received = false;
            this._endpoint.transfer(transfer);
        }
        object = this;
        synchronized (object) {
            while (!this._received) {
                try {
                    this.wait();
                }
                catch (InterruptedException e) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handle(Binary deliveryTag, DeliveryState state, Boolean settled) {
        TransactionController transactionController = this;
        synchronized (transactionController) {
            this._state = state;
            this._received = true;
            if (!Boolean.TRUE.equals(settled)) {
                this._endpoint.updateDisposition(deliveryTag, state, true);
            }
            this.notifyAll();
        }
    }

    public void close() {
        this._endpoint.close();
    }
}

