/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.amqp_1_0.jms.impl;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.UUID;
import javax.jms.BytesMessage;
import javax.jms.Destination;
import javax.jms.ExceptionListener;
import javax.jms.IllegalStateException;
import javax.jms.InvalidDestinationException;
import javax.jms.JMSException;
import javax.jms.MapMessage;
import javax.jms.MessageEOFException;
import javax.jms.MessageListener;
import javax.jms.ObjectMessage;
import javax.jms.Queue;
import javax.jms.StreamMessage;
import javax.jms.TextMessage;
import org.apache.qpid.amqp_1_0.client.AcknowledgeMode;
import org.apache.qpid.amqp_1_0.client.ChannelsExhaustedException;
import org.apache.qpid.amqp_1_0.client.Connection;
import org.apache.qpid.amqp_1_0.client.ConnectionClosedException;
import org.apache.qpid.amqp_1_0.client.ConnectionErrorException;
import org.apache.qpid.amqp_1_0.client.ConnectionException;
import org.apache.qpid.amqp_1_0.client.Message;
import org.apache.qpid.amqp_1_0.client.Receiver;
import org.apache.qpid.amqp_1_0.client.Sender;
import org.apache.qpid.amqp_1_0.client.Transaction;
import org.apache.qpid.amqp_1_0.jms.QueueReceiver;
import org.apache.qpid.amqp_1_0.jms.QueueSender;
import org.apache.qpid.amqp_1_0.jms.QueueSession;
import org.apache.qpid.amqp_1_0.jms.Session;
import org.apache.qpid.amqp_1_0.jms.SessionException;
import org.apache.qpid.amqp_1_0.jms.TemporaryDestination;
import org.apache.qpid.amqp_1_0.jms.Topic;
import org.apache.qpid.amqp_1_0.jms.TopicPublisher;
import org.apache.qpid.amqp_1_0.jms.TopicSession;
import org.apache.qpid.amqp_1_0.jms.TopicSubscriber;
import org.apache.qpid.amqp_1_0.jms.impl.AmqpMessageImpl;
import org.apache.qpid.amqp_1_0.jms.impl.BytesMessageImpl;
import org.apache.qpid.amqp_1_0.jms.impl.ConnectionImpl;
import org.apache.qpid.amqp_1_0.jms.impl.DestinationImpl;
import org.apache.qpid.amqp_1_0.jms.impl.MapMessageImpl;
import org.apache.qpid.amqp_1_0.jms.impl.MessageConsumerImpl;
import org.apache.qpid.amqp_1_0.jms.impl.MessageFactory;
import org.apache.qpid.amqp_1_0.jms.impl.MessageImpl;
import org.apache.qpid.amqp_1_0.jms.impl.MessageProducerImpl;
import org.apache.qpid.amqp_1_0.jms.impl.ObjectMessageImpl;
import org.apache.qpid.amqp_1_0.jms.impl.QueueBrowserImpl;
import org.apache.qpid.amqp_1_0.jms.impl.QueueImpl;
import org.apache.qpid.amqp_1_0.jms.impl.StreamMessageImpl;
import org.apache.qpid.amqp_1_0.jms.impl.TemporaryQueueImpl;
import org.apache.qpid.amqp_1_0.jms.impl.TemporaryTopicImpl;
import org.apache.qpid.amqp_1_0.jms.impl.TextMessageImpl;
import org.apache.qpid.amqp_1_0.jms.impl.TopicImpl;
import org.apache.qpid.amqp_1_0.jms.impl.TopicSubscriberImpl;
import org.apache.qpid.amqp_1_0.transport.SessionEventListener;
import org.apache.qpid.amqp_1_0.type.Source;
import org.apache.qpid.amqp_1_0.type.messaging.Target;
import org.apache.qpid.amqp_1_0.type.transport.AmqpError;
import org.apache.qpid.amqp_1_0.type.transport.End;
import org.apache.qpid.amqp_1_0.type.transport.Error;

public class SessionImpl
implements Session,
QueueSession,
TopicSession {
    private ConnectionImpl _connection;
    private Session.AcknowledgeMode _acknowledgeMode;
    private org.apache.qpid.amqp_1_0.client.Session _session;
    private MessageFactory _messageFactory;
    private List<MessageConsumerImpl> _consumers = new ArrayList<MessageConsumerImpl>();
    private List<MessageProducerImpl> _producers = new ArrayList<MessageProducerImpl>();
    private MessageListener _messageListener;
    private Dispatcher _dispatcher = new Dispatcher();
    private Thread _dispatcherThread;
    private boolean _closed;
    private boolean _isQueueSession;
    private boolean _isTopicSession;
    private Transaction _txn;

    protected SessionImpl(ConnectionImpl connection, Session.AcknowledgeMode acknowledgeMode) throws JMSException {
        this._connection = connection;
        this._acknowledgeMode = acknowledgeMode;
        Connection clientConn = this._connection.getClientConnection();
        try {
            this._session = clientConn.createSession();
        }
        catch (ConnectionException e) {
            JMSException jmsException = e instanceof ChannelsExhaustedException ? new JMSException(e.getMessage(), "org.apache:channels-exhausted") : new JMSException(e.getMessage());
            jmsException.setLinkedException((Exception)((Object)e));
            throw jmsException;
        }
        this._session.getEndpoint().setSessionEventListener((SessionEventListener)new SessionEventListener.DefaultSessionEventListener(){

            public void remoteEnd(End end) {
                if (!SessionImpl.this._closed) {
                    try {
                        SessionImpl.this.close();
                    }
                    catch (JMSException e) {
                        // empty catch block
                    }
                    try {
                        Error error = end == null ? null : end.getError();
                        ExceptionListener exceptionListener = SessionImpl.this._connection.getExceptionListener();
                        if (exceptionListener != null) {
                            if (error != null) {
                                SessionException se = new SessionException(error.getDescription(), error.getCondition().getValue().toString());
                                exceptionListener.onException((JMSException)se);
                            } else {
                                exceptionListener.onException((JMSException)new SessionException("Session remotely closed"));
                            }
                        }
                    }
                    catch (JMSException jMSException) {
                        // empty catch block
                    }
                }
            }
        });
        if (this._acknowledgeMode == Session.AcknowledgeMode.SESSION_TRANSACTED) {
            this._txn = this._session.createSessionLocalTransaction();
        }
        this._messageFactory = new MessageFactory(this);
    }

    @Override
    public BytesMessageImpl createBytesMessage() throws IllegalStateException {
        this.checkClosed();
        return new BytesMessageImpl(this);
    }

    @Override
    public MapMessageImpl createMapMessage() throws JMSException {
        this.checkClosed();
        return new MapMessageImpl(this);
    }

    @Override
    public MessageImpl createMessage() throws IllegalStateException {
        return this.createAmqpMessage();
    }

    @Override
    public ObjectMessageImpl createObjectMessage() throws JMSException {
        this.checkClosed();
        return new ObjectMessageImpl(this);
    }

    @Override
    public ObjectMessageImpl createObjectMessage(Serializable serializable) throws JMSException {
        this.checkClosed();
        ObjectMessageImpl msg = new ObjectMessageImpl(this);
        msg.setObject(serializable);
        return msg;
    }

    @Override
    public StreamMessageImpl createStreamMessage() throws JMSException {
        this.checkClosed();
        return new StreamMessageImpl(this);
    }

    @Override
    public TextMessageImpl createTextMessage() throws JMSException {
        return this.createTextMessage("");
    }

    @Override
    public TextMessageImpl createTextMessage(String s) throws JMSException {
        this.checkClosed();
        TextMessageImpl msg = new TextMessageImpl(this);
        msg.setText(s);
        return msg;
    }

    @Override
    public AmqpMessageImpl createAmqpMessage() throws IllegalStateException {
        this.checkClosed();
        return new AmqpMessageImpl(this);
    }

    public boolean getTransacted() throws JMSException {
        this.checkClosed();
        return this._acknowledgeMode == Session.AcknowledgeMode.SESSION_TRANSACTED;
    }

    public int getAcknowledgeMode() throws IllegalStateException {
        this.checkClosed();
        return this._acknowledgeMode.ordinal();
    }

    Session.AcknowledgeMode getAckModeEnum() {
        return this._acknowledgeMode;
    }

    public void commit() throws JMSException {
        this.checkClosed();
        this.checkTransactional();
        this._txn.commit();
        for (MessageConsumerImpl consumer : this._consumers) {
            consumer.postCommit();
        }
        this._txn = this._session.createSessionLocalTransaction();
    }

    public void rollback() throws JMSException {
        this.checkClosed();
        this.checkTransactional();
        this._txn.rollback();
        for (MessageConsumerImpl consumer : this._consumers) {
            consumer.postRollback();
        }
        this._txn = this._session.createSessionLocalTransaction();
    }

    private void checkTransactional() throws JMSException {
        if (!this.getTransacted()) {
            throw new IllegalStateException("Session must be transacted in order to perform this operation");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws JMSException {
        if (!this._closed) {
            this._closed = true;
            this._dispatcher.close();
            ArrayList<MessageConsumerImpl> consumers = null;
            ArrayList<MessageProducerImpl> producers = null;
            Object object = this._session.getEndpoint().getLock();
            synchronized (object) {
                consumers = new ArrayList<MessageConsumerImpl>(this._consumers);
                producers = new ArrayList<MessageProducerImpl>(this._producers);
            }
            for (MessageConsumerImpl consumer : consumers) {
                consumer.close();
            }
            for (MessageProducerImpl producer : producers) {
                producer.close();
            }
            this._session.close();
            this._connection.removeSession(this);
        }
    }

    private void checkClosed() throws IllegalStateException {
        if (this._closed) {
            throw new IllegalStateException("Closed");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void recover() throws JMSException {
        this.checkClosed();
        this.checkNotTransactional();
        if (this._acknowledgeMode == Session.AcknowledgeMode.CLIENT_ACKNOWLEDGE) {
            Object object = this._session.getEndpoint().getLock();
            synchronized (object) {
                for (MessageConsumerImpl consumer : this._consumers) {
                    consumer.doRecover();
                }
            }
        } else if (Thread.currentThread() == this._dispatcherThread) {
            this._dispatcher.doRecover();
        }
    }

    private void checkNotTransactional() throws JMSException {
        if (this.getTransacted()) {
            throw new IllegalStateException("This operation cannot be carried out on a transacted session");
        }
    }

    public MessageListener getMessageListener() throws JMSException {
        return this._messageListener;
    }

    public void setMessageListener(MessageListener messageListener) throws JMSException {
        if (this._messageListener == null) {
            this._messageListener = messageListener;
        }
    }

    public void run() {
    }

    @Override
    public MessageProducerImpl createProducer(Destination destination) throws JMSException {
        this.checkClosed();
        MessageProducerImpl messageProducer = new MessageProducerImpl(destination, this);
        this._producers.add(messageProducer);
        return messageProducer;
    }

    @Override
    public MessageConsumerImpl createConsumer(Destination destination) throws JMSException {
        this.checkClosed();
        return this.createConsumer(destination, null, false);
    }

    @Override
    public MessageConsumerImpl createConsumer(Destination destination, String selector) throws JMSException {
        this.checkClosed();
        return this.createConsumer(destination, selector, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public MessageConsumerImpl createConsumer(Destination destination, String selector, boolean noLocal) throws JMSException {
        MessageConsumerImpl messageConsumer;
        this.checkClosed();
        this.checkValidDestination(destination);
        if (destination instanceof TemporaryDestination) {
            TemporaryDestination temporaryDestination = (TemporaryDestination)destination;
            if (temporaryDestination.getSession() != this) {
                throw new JMSException("Cannot consume from a temporary destination created on another session");
            }
            if (temporaryDestination.isDeleted()) {
                throw new IllegalStateException("Destination is deleted");
            }
        }
        Object object = this._session.getEndpoint().getLock();
        synchronized (object) {
            if (this._dispatcherThread == null) {
                this._dispatcherThread = new Thread(this._dispatcher);
                this._dispatcherThread.start();
            }
            messageConsumer = new MessageConsumerImpl(destination, this, selector, noLocal);
            this.addConsumer(messageConsumer);
            if (this._connection.isStarted()) {
                messageConsumer.start();
            }
        }
        return messageConsumer;
    }

    private void checkValidDestination(Destination destination) throws InvalidDestinationException {
        if (destination == null || !(destination instanceof DestinationImpl)) {
            throw new InvalidDestinationException("Invalid Destination");
        }
    }

    protected void addConsumer(MessageConsumerImpl messageConsumer) {
        this._consumers.add(messageConsumer);
    }

    @Override
    public QueueImpl createQueue(String s) throws JMSException {
        this.checkClosed();
        this.checkNotTopicSession();
        return new QueueImpl(s);
    }

    @Override
    public QueueReceiver createReceiver(Queue queue) throws JMSException {
        this.checkClosed();
        this.checkNotTopicSession();
        return this.createConsumer((Destination)queue);
    }

    @Override
    public QueueReceiver createReceiver(Queue queue, String selector) throws JMSException {
        this.checkClosed();
        this.checkNotTopicSession();
        return this.createConsumer((Destination)queue, selector);
    }

    @Override
    public QueueSender createSender(Queue queue) throws JMSException {
        this.checkClosed();
        this.checkNotTopicSession();
        return this.createProducer((Destination)queue);
    }

    @Override
    public TopicImpl createTopic(String s) throws JMSException {
        this.checkClosed();
        this.checkNotQueueSession();
        return new TopicImpl(s);
    }

    @Override
    public TopicSubscriber createSubscriber(javax.jms.Topic topic) throws JMSException {
        this.checkClosed();
        this.checkNotQueueSession();
        return this.createConsumer((Destination)topic);
    }

    @Override
    public TopicSubscriber createSubscriber(javax.jms.Topic topic, String selector, boolean noLocal) throws JMSException {
        this.checkClosed();
        this.checkNotQueueSession();
        return this.createConsumer((Destination)topic, selector, noLocal);
    }

    @Override
    public TopicSubscriberImpl createDurableSubscriber(javax.jms.Topic topic, String name) throws JMSException {
        this.checkClosed();
        this.checkNotQueueSession();
        return this.createDurableSubscriber(topic, name, null, false);
    }

    private void checkNotQueueSession() throws IllegalStateException {
        if (this._isQueueSession) {
            throw new IllegalStateException("Cannot perform this operation on a QueueSession");
        }
    }

    private void checkNotTopicSession() throws IllegalStateException {
        if (this._isTopicSession) {
            throw new IllegalStateException("Cannot perform this operation on a TopicSession");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public TopicSubscriberImpl createDurableSubscriber(javax.jms.Topic topic, String name, String selector, boolean noLocal) throws JMSException {
        TopicSubscriberImpl messageConsumer;
        this.checkClosed();
        this.checkNotQueueSession();
        if (!(topic instanceof TopicImpl)) {
            throw new InvalidDestinationException("invalid destination " + topic);
        }
        Object object = this._session.getEndpoint().getLock();
        synchronized (object) {
            messageConsumer = new TopicSubscriberImpl(name, true, (Topic)topic, this, selector, noLocal);
            if (this._dispatcherThread == null) {
                this._dispatcherThread = new Thread(this._dispatcher);
                this._dispatcherThread.start();
            }
            this.addConsumer(messageConsumer);
            if (this._connection.isStarted()) {
                messageConsumer.start();
            }
        }
        return messageConsumer;
    }

    @Override
    public TopicPublisher createPublisher(javax.jms.Topic topic) throws JMSException {
        this.checkClosed();
        this.checkNotQueueSession();
        return this.createProducer((Destination)topic);
    }

    @Override
    public QueueBrowserImpl createBrowser(Queue queue) throws JMSException {
        this.checkClosed();
        this.checkNotTopicSession();
        this.checkValidDestination((Destination)queue);
        return this.createBrowser(queue, null);
    }

    @Override
    public QueueBrowserImpl createBrowser(Queue queue, String selector) throws JMSException {
        this.checkClosed();
        this.checkNotTopicSession();
        this.checkValidDestination((Destination)queue);
        return new QueueBrowserImpl((QueueImpl)queue, selector, this);
    }

    @Override
    public TemporaryQueueImpl createTemporaryQueue() throws JMSException {
        this.checkClosed();
        this.checkNotTopicSession();
        try {
            Sender send = this._session.createTemporaryQueueSender();
            TemporaryQueueImpl tempQ = new TemporaryQueueImpl(((Target)send.getTarget()).getAddress(), send, this);
            return tempQ;
        }
        catch (Sender.SenderCreationException e) {
            throw new JMSException("Unable to create temporary queue");
        }
        catch (ConnectionClosedException e) {
            throw new JMSException("Unable to create temporary queue");
        }
    }

    @Override
    public TemporaryTopicImpl createTemporaryTopic() throws JMSException {
        this.checkClosed();
        this.checkNotQueueSession();
        try {
            Sender send = this._session.createTemporaryQueueSender();
            TemporaryTopicImpl tempQ = new TemporaryTopicImpl(((Target)send.getTarget()).getAddress(), send, this);
            return tempQ;
        }
        catch (Sender.SenderCreationException e) {
            throw new JMSException("Unable to create temporary queue");
        }
        catch (ConnectionClosedException e) {
            throw new JMSException("Unable to create temporary queue");
        }
    }

    public void unsubscribe(String s) throws JMSException {
        this.checkClosed();
        this.checkNotQueueSession();
        Target target = new Target();
        target.setAddress(UUID.randomUUID().toString());
        try {
            Receiver receiver = new Receiver(this.getClientSession(), s, target, null, AcknowledgeMode.ALO, false);
            Source receiverSource = receiver.getSource();
            if (receiverSource instanceof org.apache.qpid.amqp_1_0.type.messaging.Source) {
                org.apache.qpid.amqp_1_0.type.messaging.Source source = (org.apache.qpid.amqp_1_0.type.messaging.Source)receiverSource;
                receiver.close();
                receiver = new Receiver(this.getClientSession(), s, target, source, AcknowledgeMode.ALO, false);
            }
            receiver.close();
        }
        catch (ConnectionErrorException e) {
            if (e.getRemoteError().getCondition() == AmqpError.NOT_FOUND) {
                throw new InvalidDestinationException(s);
            }
            JMSException jmsException = new JMSException(e.getMessage());
            jmsException.setLinkedException((Exception)((Object)e));
            throw jmsException;
        }
    }

    void stop() {
    }

    void start() {
        this._dispatcher.start();
        for (MessageConsumerImpl consumer : this._consumers) {
            consumer.start();
        }
    }

    org.apache.qpid.amqp_1_0.client.Session getClientSession() {
        return this._session;
    }

    public MessageFactory getMessageFactory() {
        return this._messageFactory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void acknowledgeAll() throws IllegalStateException {
        Object object = this._session.getEndpoint().getLock();
        synchronized (object) {
            this.checkClosed();
            for (MessageConsumerImpl consumer : this._consumers) {
                consumer.acknowledgeAll();
            }
        }
    }

    void messageListenerSet(MessageConsumerImpl messageConsumer) {
        this._dispatcher.updateMessageListener(messageConsumer);
    }

    public void messageArrived(MessageConsumerImpl messageConsumer) {
        this._dispatcher.messageArrivedAtConsumer(messageConsumer);
    }

    MessageImpl convertMessage(javax.jms.Message message) throws JMSException {
        MessageImpl replacementMessage = message instanceof BytesMessage ? this.convertBytesMessage((BytesMessage)message) : (message instanceof MapMessage ? this.convertMapMessage((MapMessage)message) : (message instanceof ObjectMessage ? this.convertObjectMessage((ObjectMessage)message) : (message instanceof StreamMessage ? this.convertStreamMessage((StreamMessage)message) : (message instanceof TextMessage ? this.convertTextMessage((TextMessage)message) : this.createMessage()))));
        this.convertMessageProperties(message, replacementMessage);
        return replacementMessage;
    }

    private void convertMessageProperties(javax.jms.Message message, MessageImpl replacementMessage) throws JMSException {
        Enumeration propertyNames = message.getPropertyNames();
        while (propertyNames.hasMoreElements()) {
            String propertyName = String.valueOf(propertyNames.nextElement());
            if (propertyName.startsWith("JMSX_")) continue;
            Object value = message.getObjectProperty(propertyName);
            replacementMessage.setObjectProperty(propertyName, value);
        }
        replacementMessage.setJMSDeliveryMode(message.getJMSDeliveryMode());
        if (message.getJMSReplyTo() != null) {
            replacementMessage.setJMSReplyTo(message.getJMSReplyTo());
        }
        replacementMessage.setJMSType(message.getJMSType());
        replacementMessage.setJMSCorrelationID(message.getJMSCorrelationID());
    }

    private MessageImpl convertMapMessage(MapMessage message) throws JMSException {
        MapMessageImpl mapMessage = this.createMapMessage();
        Enumeration mapNames = message.getMapNames();
        while (mapNames.hasMoreElements()) {
            String name = (String)mapNames.nextElement();
            mapMessage.setObject(name, message.getObject(name));
        }
        return mapMessage;
    }

    private MessageImpl convertBytesMessage(BytesMessage message) throws JMSException {
        int len;
        BytesMessageImpl bytesMessage = this.createBytesMessage();
        message.reset();
        byte[] buf = new byte[1024];
        while ((len = message.readBytes(buf)) != -1) {
            bytesMessage.writeBytes(buf, 0, len);
        }
        return bytesMessage;
    }

    private MessageImpl convertObjectMessage(ObjectMessage message) throws JMSException {
        ObjectMessageImpl objectMessage = this.createObjectMessage();
        objectMessage.setObject(message.getObject());
        return objectMessage;
    }

    private MessageImpl convertStreamMessage(StreamMessage message) throws JMSException {
        StreamMessageImpl streamMessage = this.createStreamMessage();
        try {
            message.reset();
            while (true) {
                streamMessage.writeObject(message.readObject());
            }
        }
        catch (MessageEOFException messageEOFException) {
            return streamMessage;
        }
    }

    private MessageImpl convertTextMessage(TextMessage message) throws JMSException {
        return this.createTextMessage(message.getText());
    }

    ConnectionImpl getConnection() {
        return this._connection;
    }

    Transaction getTxn() {
        return this._txn;
    }

    void setQueueSession(boolean queueSession) {
        this._isQueueSession = queueSession;
    }

    void setTopicSession(boolean topicSession) {
        this._isTopicSession = topicSession;
    }

    String toAddress(DestinationImpl dest) {
        return this._connection.toDecodedDestination(dest).getAddress();
    }

    private class Dispatcher
    implements Runnable {
        private final List<MessageConsumerImpl> _messageConsumerList = new ArrayList<MessageConsumerImpl>();
        private boolean _closed;
        private boolean _started;
        private Message _recoveredMessage;
        private MessageConsumerImpl _recoveredConsumer;
        private MessageConsumerImpl _currentConsumer;
        private Message _currentMessage;

        private Dispatcher() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            Object object = this.getLock();
            synchronized (object) {
                while (!this._closed) {
                    MessageConsumerImpl consumer;
                    while (!this._closed && (!this._started || this._recoveredMessage == null && this._messageConsumerList.isEmpty())) {
                        try {
                            this.getLock().wait();
                        }
                        catch (InterruptedException e) {
                            return;
                        }
                    }
                    while (!(this._closed || !this._started || this._recoveredMessage == null && this._messageConsumerList.isEmpty())) {
                        Message msg;
                        boolean recoveredMessage;
                        boolean bl = recoveredMessage = this._recoveredMessage != null;
                        if (recoveredMessage) {
                            consumer = this._recoveredConsumer;
                            msg = this._recoveredMessage;
                            this._recoveredMessage = null;
                            this._recoveredConsumer = null;
                        } else {
                            consumer = this._messageConsumerList.remove(0);
                            msg = consumer.receive0(0L);
                        }
                        MessageListener listener = consumer._messageListener;
                        MessageImpl message = consumer.createJMSMessage(msg, recoveredMessage);
                        if (message == null) continue;
                        if (SessionImpl.this._acknowledgeMode == Session.AcknowledgeMode.CLIENT_ACKNOWLEDGE) {
                            consumer.setLastUnackedMessage(msg.getDeliveryTag());
                        }
                        this._currentConsumer = consumer;
                        this._currentMessage = msg;
                        try {
                            listener.onMessage((javax.jms.Message)message);
                        }
                        finally {
                            this._currentConsumer = null;
                            this._currentMessage = null;
                        }
                        if (this._recoveredMessage != null) continue;
                        consumer.preReceiveAction(msg);
                    }
                    Iterator consumers = SessionImpl.this._consumers.iterator();
                    while (consumers.hasNext()) {
                        consumer = (MessageConsumerImpl)consumers.next();
                        try {
                            consumer.checkReceiverError();
                        }
                        catch (JMSException e) {
                            consumers.remove();
                            try {
                                ExceptionListener expListener = SessionImpl.this._connection.getExceptionListener();
                                if (expListener != null) {
                                    expListener.onException(e);
                                }
                                consumer.close();
                            }
                            catch (JMSException e1) {}
                        }
                    }
                }
            }
        }

        private Object getLock() {
            return SessionImpl.this._session.getEndpoint().getLock();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void messageArrivedAtConsumer(MessageConsumerImpl impl) {
            Object object = this.getLock();
            synchronized (object) {
                this._messageConsumerList.add(impl);
                this.getLock().notifyAll();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void close() {
            Object object = this.getLock();
            synchronized (object) {
                this._closed = true;
                this.getLock().notifyAll();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void updateMessageListener(MessageConsumerImpl messageConsumer) {
            Object object = this.getLock();
            synchronized (object) {
                this.getLock().notifyAll();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void start() {
            Object object = this.getLock();
            synchronized (object) {
                this._started = true;
                this.getLock().notifyAll();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void stop() {
            Object object = this.getLock();
            synchronized (object) {
                this._started = false;
                this.getLock().notifyAll();
            }
        }

        public void doRecover() {
            this._recoveredConsumer = this._currentConsumer;
            this._recoveredMessage = this._currentMessage;
        }
    }
}

