/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.amqp_1_0.jms.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import javax.jms.Destination;
import javax.jms.ExceptionListener;
import javax.jms.IllegalStateException;
import javax.jms.InvalidDestinationException;
import javax.jms.InvalidSelectorException;
import javax.jms.JMSException;
import javax.jms.MessageListener;
import org.apache.qpid.amqp_1_0.client.AcknowledgeMode;
import org.apache.qpid.amqp_1_0.client.ConnectionErrorException;
import org.apache.qpid.amqp_1_0.client.Message;
import org.apache.qpid.amqp_1_0.client.Receiver;
import org.apache.qpid.amqp_1_0.client.Transaction;
import org.apache.qpid.amqp_1_0.jms.MessageConsumer;
import org.apache.qpid.amqp_1_0.jms.MessageConsumerException;
import org.apache.qpid.amqp_1_0.jms.Queue;
import org.apache.qpid.amqp_1_0.jms.QueueReceiver;
import org.apache.qpid.amqp_1_0.jms.Session;
import org.apache.qpid.amqp_1_0.jms.TemporaryDestination;
import org.apache.qpid.amqp_1_0.jms.Topic;
import org.apache.qpid.amqp_1_0.jms.TopicSubscriber;
import org.apache.qpid.amqp_1_0.jms.impl.DestinationImpl;
import org.apache.qpid.amqp_1_0.jms.impl.MessageFactory;
import org.apache.qpid.amqp_1_0.jms.impl.MessageImpl;
import org.apache.qpid.amqp_1_0.jms.impl.SessionImpl;
import org.apache.qpid.amqp_1_0.type.Binary;
import org.apache.qpid.amqp_1_0.type.Outcome;
import org.apache.qpid.amqp_1_0.type.Symbol;
import org.apache.qpid.amqp_1_0.type.UnsignedInteger;
import org.apache.qpid.amqp_1_0.type.messaging.Filter;
import org.apache.qpid.amqp_1_0.type.messaging.JMSSelectorFilter;
import org.apache.qpid.amqp_1_0.type.messaging.Modified;
import org.apache.qpid.amqp_1_0.type.messaging.NoLocalFilter;
import org.apache.qpid.amqp_1_0.type.transport.AmqpError;
import org.apache.qpid.amqp_1_0.type.transport.Error;

public class MessageConsumerImpl
implements MessageConsumer,
QueueReceiver,
TopicSubscriber {
    private static final Symbol NO_LOCAL_FILTER_NAME = Symbol.valueOf((String)"no-local");
    private static final Symbol JMS_SELECTOR_FILTER_NAME = Symbol.valueOf((String)"jms-selector");
    private String _selector;
    private boolean _noLocal;
    private DestinationImpl _destination;
    private SessionImpl _session;
    private Receiver _receiver;
    private Binary _lastUnackedMessage;
    MessageListener _messageListener;
    private boolean _isQueueConsumer;
    private boolean _isTopicSubscriber;
    private boolean _closed = false;
    private String _linkName;
    private boolean _durable;
    private Collection<Binary> _txnMsgs = Collections.synchronizedCollection(new ArrayList());
    private Binary _lastTxnUpdate;
    private final List<Message> _recoverReplayMessages = new ArrayList<Message>();
    private final List<Message> _replaymessages = new ArrayList<Message>();
    private int _maxPrefetch = 100;

    MessageConsumerImpl(Destination destination, SessionImpl session, String selector, boolean noLocal) throws JMSException {
        this(destination, session, selector, noLocal, null, false);
    }

    MessageConsumerImpl(Destination destination, SessionImpl session, String selector, boolean noLocal, String linkName, boolean durable) throws JMSException {
        this._selector = selector;
        this._noLocal = noLocal;
        this._linkName = linkName;
        this._durable = durable;
        if (destination instanceof DestinationImpl) {
            this._destination = (DestinationImpl)destination;
            if (destination instanceof javax.jms.Queue) {
                this._isQueueConsumer = true;
            } else if (destination instanceof javax.jms.Topic) {
                this._isTopicSubscriber = true;
            }
            if (destination instanceof TemporaryDestination) {
                ((TemporaryDestination)destination).addConsumer(this);
            }
        } else {
            throw new InvalidDestinationException("Invalid destination class " + destination.getClass().getName());
        }
        this._session = session;
        if (session.getMaxPrefetch() != 0) {
            this._maxPrefetch = session.getMaxPrefetch();
        }
        this._receiver = this.createClientReceiver();
        this._receiver.setRemoteErrorListener(new Runnable(){

            @Override
            public void run() {
                try {
                    ExceptionListener exceptionListener = MessageConsumerImpl.this._session.getConnection().getExceptionListener();
                    if (exceptionListener != null) {
                        Error receiverError = MessageConsumerImpl.this._receiver.getError();
                        MessageConsumerException mce = new MessageConsumerException(receiverError.getDescription(), receiverError.getCondition().getValue().toString(), MessageConsumerImpl.this._destination.getAddress());
                        exceptionListener.onException((JMSException)mce);
                    }
                }
                catch (JMSException jMSException) {
                    // empty catch block
                }
            }
        });
    }

    protected Receiver createClientReceiver() throws JMSException {
        try {
            String targetAddr = this._destination.getLocalTerminus() != null ? this._destination.getLocalTerminus() : UUID.randomUUID().toString();
            return this._session.getClientSession().createReceiver(this._session.toAddress(this._destination), targetAddr, AcknowledgeMode.ALO, this._linkName, this._durable, this.getFilters(), null);
        }
        catch (ConnectionErrorException e) {
            Error error = e.getRemoteError();
            if (AmqpError.INVALID_FIELD.equals(error.getCondition())) {
                throw new InvalidSelectorException(e.getMessage());
            }
            throw new JMSException(e.getMessage(), error.getCondition().getValue().toString());
        }
    }

    Map<Symbol, Filter> getFilters() {
        if (this._selector == null || this._selector.trim().equals("")) {
            if (this._noLocal) {
                return Collections.singletonMap(NO_LOCAL_FILTER_NAME, NoLocalFilter.INSTANCE);
            }
            return null;
        }
        if (this._noLocal) {
            HashMap<Symbol, Filter> filters = new HashMap<Symbol, Filter>();
            filters.put(NO_LOCAL_FILTER_NAME, (Filter)NoLocalFilter.INSTANCE);
            filters.put(JMS_SELECTOR_FILTER_NAME, (Filter)new JMSSelectorFilter(this._selector));
            return filters;
        }
        return Collections.singletonMap(JMS_SELECTOR_FILTER_NAME, new JMSSelectorFilter(this._selector));
    }

    public String getMessageSelector() throws JMSException {
        this.checkClosed();
        return this._selector;
    }

    public MessageListener getMessageListener() throws IllegalStateException {
        this.checkClosed();
        return this._messageListener;
    }

    public void setMessageListener(MessageListener messageListener) throws JMSException {
        this.checkClosed();
        this._messageListener = messageListener;
        this._receiver.setMessageArrivalListener(new Receiver.MessageArrivalListener(){

            public void messageArrived(Receiver receiver) {
                MessageConsumerImpl.this._session.messageArrived(MessageConsumerImpl.this);
            }
        });
        this._session.messageListenerSet(this);
    }

    @Override
    public MessageImpl receive() throws JMSException {
        this.checkClosed();
        return this.receiveImpl(-1L);
    }

    @Override
    public MessageImpl receive(long timeout) throws JMSException {
        this.checkClosed();
        return this.receiveImpl(timeout);
    }

    @Override
    public MessageImpl receiveNoWait() throws JMSException {
        this.checkClosed();
        return this.receiveImpl(0L);
    }

    private MessageImpl receiveImpl(long timeout) throws JMSException {
        boolean redelivery;
        Message msg;
        if (this._replaymessages.isEmpty()) {
            this.checkReceiverError();
            msg = this.receive0(timeout);
            redelivery = false;
        } else {
            msg = this._replaymessages.remove(0);
            redelivery = true;
        }
        if (msg != null) {
            this.preReceiveAction(msg);
        }
        return this.createJMSMessage(msg, redelivery);
    }

    void checkReceiverError() throws JMSException {
        Error receiverError = this._receiver.getError();
        if (receiverError != null) {
            JMSException jmsException = new JMSException(receiverError.getDescription(), receiverError.getCondition().toString());
            throw jmsException;
        }
    }

    Message receive0(long timeout) {
        Message message = this._receiver.receive(timeout);
        if (this._session.getAckModeEnum() == Session.AcknowledgeMode.CLIENT_ACKNOWLEDGE) {
            this._recoverReplayMessages.add(message);
        }
        return message;
    }

    void acknowledge(Message msg) {
        this._receiver.acknowledge(msg.getDeliveryTag(), this._session.getTxn());
    }

    MessageImpl createJMSMessage(Message msg, boolean redelivery) {
        if (msg != null) {
            MessageFactory factory = this._session.getMessageFactory();
            MessageImpl message = factory.createMessage(this._destination, msg);
            message.setFromQueue(this._isQueueConsumer);
            message.setFromTopic(this._isTopicSubscriber);
            if (redelivery && !message.getJMSRedelivered()) {
                message.setJMSRedelivered(true);
            }
            return message;
        }
        return null;
    }

    public void close() throws JMSException {
        if (!this._closed) {
            this._closed = true;
            this.closeUnderlyingReceiver(this._receiver);
            if (this._destination instanceof TemporaryDestination) {
                ((TemporaryDestination)((Object)this._destination)).removeConsumer(this);
            }
        }
    }

    protected void closeUnderlyingReceiver(Receiver receiver) {
        receiver.close();
    }

    private void checkClosed() throws IllegalStateException {
        if (this._closed) {
            throw new IllegalStateException("Closed");
        }
    }

    void setLastUnackedMessage(Binary deliveryTag) {
        this._lastUnackedMessage = deliveryTag;
    }

    void preReceiveAction(Message msg) {
        int acknowledgeMode = this._session.getAckModeEnum().ordinal();
        if (acknowledgeMode == 1 || acknowledgeMode == 3 || acknowledgeMode == 0) {
            this.acknowledge(msg);
            if (acknowledgeMode == 0) {
                this._txnMsgs.add(msg.getDeliveryTag());
            }
        } else if (acknowledgeMode == 2) {
            this.setLastUnackedMessage(msg.getDeliveryTag());
        }
    }

    void acknowledgeAll() {
        if (this._lastUnackedMessage != null) {
            Transaction txn = this._session.getTxn();
            this._receiver.acknowledgeAll(this._lastUnackedMessage, txn, null);
            if (txn != null) {
                this._lastTxnUpdate = this._lastUnackedMessage;
            }
            this._lastUnackedMessage = null;
        }
        this._recoverReplayMessages.clear();
        if (!this._replaymessages.isEmpty()) {
            this._recoverReplayMessages.addAll(this._replaymessages);
        }
    }

    void postRollback() {
        if (this._lastTxnUpdate != null) {
            Modified outcome = new Modified();
            outcome.setDeliveryFailed(Boolean.valueOf(true));
            this._receiver.updateAll((Outcome)outcome, this._lastTxnUpdate);
            this._lastTxnUpdate = null;
        }
        for (Binary tag : this._txnMsgs) {
            this._receiver.modified(tag);
        }
        this._txnMsgs.clear();
    }

    void postCommit() {
        this._lastTxnUpdate = null;
        this._txnMsgs.clear();
    }

    public DestinationImpl getDestination() throws IllegalStateException {
        this.checkClosed();
        return this._destination;
    }

    public SessionImpl getSession() throws IllegalStateException {
        this.checkClosed();
        return this._session;
    }

    public boolean getNoLocal() throws IllegalStateException {
        this.checkClosed();
        return this._noLocal;
    }

    public void start() {
        this._receiver.setCredit(UnsignedInteger.valueOf((int)this.getMaxPrefetch()), true);
    }

    @Override
    public Queue getQueue() throws JMSException {
        return (Queue)((Object)this.getDestination());
    }

    @Override
    public Topic getTopic() throws JMSException {
        return (Topic)((Object)this.getDestination());
    }

    void setQueueConsumer(boolean queueConsumer) {
        this._isQueueConsumer = queueConsumer;
    }

    void setTopicSubscriber(boolean topicSubscriber) {
        this._isTopicSubscriber = topicSubscriber;
    }

    String getLinkName() {
        return this._linkName;
    }

    boolean isDurable() {
        return this._durable;
    }

    void doRecover() {
        this._replaymessages.clear();
        if (!this._recoverReplayMessages.isEmpty()) {
            this._replaymessages.addAll(this._recoverReplayMessages);
            for (Message msg : this._replaymessages) {
                this._session.messageArrived(this);
            }
        }
    }

    public int getMaxPrefetch() {
        return this._maxPrefetch;
    }

    public void setMaxPrefetch(int maxPrefetch) {
        this._maxPrefetch = maxPrefetch;
    }
}

