/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.mq.fabric.camel;

import org.apache.activemq.ActiveMQConnectionFactory;
import org.apache.camel.CamelContext;
import org.apache.camel.Component;
import org.apache.camel.spi.ComponentResolver;
import org.apache.camel.util.ObjectHelper;
import org.apache.felix.scr.annotations.Activate;
import org.apache.felix.scr.annotations.Deactivate;
import org.apache.felix.scr.annotations.Property;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.Service;
import org.fusesource.mq.fabric.camel.AMQComponent;

@Service(value={ComponentResolver.class})
@Property(name="component", value={"amq"})
@org.apache.felix.scr.annotations.Component(name="org.fusesource.mq.fabric.camel.resolver", label="JBoss A-MQ Fabric Camel Component Resolver", immediate=true, metatype=false)
public class AMQComponentResolver
implements ComponentResolver {
    @Reference(referenceInterface=ActiveMQConnectionFactory.class)
    private ActiveMQConnectionFactory connectionFactory;

    @Activate
    void activate() throws Exception {
        ObjectHelper.notNull((Object)this.connectionFactory, (String)"connectionFactory", (Object)this);
    }

    @Deactivate
    void deactivate() {
    }

    public Component resolveComponent(String name, CamelContext camelContext) throws Exception {
        if (name.equals("amq") || name.equals("activemq")) {
            System.out.println("Creating an instance of the AMQComponent");
            return new AMQComponent(camelContext, this.connectionFactory);
        }
        return null;
    }

    protected void bindConnectionFactory(ActiveMQConnectionFactory activeMQConnectionFactory) {
        this.connectionFactory = activeMQConnectionFactory;
    }

    protected void unbindConnectionFactory(ActiveMQConnectionFactory activeMQConnectionFactory) {
        if (this.connectionFactory == activeMQConnectionFactory) {
            this.connectionFactory = null;
        }
    }
}

