/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.mq.fabric.http;

import io.fabric8.groups.NodeState;
import io.fabric8.groups.internal.ZooKeeperGroup;
import io.fabric8.zookeeper.utils.ZooKeeperUtils;
import java.io.IOException;
import java.util.HashSet;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.curator.framework.CuratorFramework;
import org.codehaus.jackson.annotate.JsonProperty;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FabricDiscoveryServlet
extends HttpServlet {
    private static final Logger LOG = LoggerFactory.getLogger(FabricDiscoveryServlet.class);
    volatile CuratorFramework curator = null;
    long cacheTimeout = 1000L;
    ConcurrentHashMap<String, CacheEntry> cache = new ConcurrentHashMap();

    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        CuratorFramework curator = this.curator;
        if (curator == null) {
            resp.sendError(404, "Not attached to Fabric");
            return;
        }
        try {
            String groupName = req.getPathInfo();
            if (groupName == null) {
                groupName = "";
            }
            if (groupName.startsWith("/")) {
                groupName = groupName.substring(1);
            }
            LOG.debug("discovery request for group name=" + groupName);
            CacheEntry cacheEntry = this.cache.get(groupName);
            long now = System.currentTimeMillis();
            if (cacheEntry == null || cacheEntry.timestamp + this.cacheTimeout < now) {
                try {
                    Map members = ZooKeeperGroup.members((CuratorFramework)curator, (String)("/fabric/registry/clusters/fusemq/" + groupName), ActiveMQNode.class);
                    HashSet<String> masters = new HashSet<String>();
                    StringBuilder buff = new StringBuilder();
                    for (ActiveMQNode node : members.values()) {
                        if (masters.contains(node.getId())) continue;
                        for (int i = 0; i < node.services.length; ++i) {
                            String url = node.services[i];
                            url = ZooKeeperUtils.getSubstitutedData((CuratorFramework)curator, (String)url);
                            buff.append(url);
                            buff.append('\n');
                        }
                        masters.add(node.getId());
                    }
                    cacheEntry = new CacheEntry(buff.toString(), now);
                }
                catch (Exception e) {
                    cacheEntry = new CacheEntry(null, now);
                }
                this.cache.put(groupName, cacheEntry);
            }
            if (cacheEntry.result != null) {
                resp.getWriter().print(cacheEntry.result.toString());
            } else {
                resp.sendError(404, "Group not found");
            }
        }
        catch (Exception e) {
            resp.sendError(500, "Error occurred: " + e);
        }
    }

    public long getCacheTimeout() {
        return this.cacheTimeout;
    }

    public void setCacheTimeout(long cacheTimeout) {
        this.cacheTimeout = cacheTimeout;
    }

    public CuratorFramework getCurator() {
        return this.curator;
    }

    public void setCurator(CuratorFramework curator) {
        this.curator = curator;
    }

    static class ActiveMQNode
    extends NodeState {
        @JsonProperty
        String[] services;

        ActiveMQNode() {
        }
    }

    static class CacheEntry {
        long timestamp;
        String result;

        CacheEntry(String result, long timestamp) {
            this.result = result;
            this.timestamp = timestamp;
        }
    }
}

