/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.mq.itests;

import io.fabric8.api.ServiceProxy;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.apache.activemq.command.DiscoveryEvent;
import org.apache.activemq.transport.discovery.DiscoveryListener;
import org.apache.curator.framework.CuratorFramework;
import org.apache.karaf.tooling.exam.options.KarafDistributionOption;
import org.apache.karaf.tooling.exam.options.LogLevelOption;
import org.fusesource.mq.fabric.FabricDiscoveryAgent;
import org.fusesource.mq.itests.MQTestSupport;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.ops4j.pax.exam.Option;
import org.ops4j.pax.exam.junit.Configuration;
import org.ops4j.pax.exam.junit.ExamReactorStrategy;
import org.ops4j.pax.exam.junit.JUnit4TestRunner;
import org.ops4j.pax.exam.options.DefaultCompositeOption;
import org.ops4j.pax.exam.spi.reactors.AllConfinedStagedReactorFactory;
import org.osgi.framework.BundleContext;

@RunWith(value=JUnit4TestRunner.class)
@ExamReactorStrategy(value={AllConfinedStagedReactorFactory.class})
public class MQFabricTest
extends MQTestSupport {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testLocalFabricCluster() throws Exception {
        String groupName = "default";
        System.out.println(MQFabricTest.executeCommand((String)"fabric:create -n --clean root"));
        ServiceProxy curatorProxy = ServiceProxy.createServiceProxy((BundleContext)this.bundleContext, CuratorFramework.class);
        try {
            CuratorFramework curator = (CuratorFramework)curatorProxy.getService();
            final CountDownLatch serviceLatch = new CountDownLatch(1);
            FabricDiscoveryAgent discoveryAgent = new FabricDiscoveryAgent();
            discoveryAgent.setCurator(curator);
            discoveryAgent.setGroupName("default");
            discoveryAgent.setDiscoveryListener(new DiscoveryListener(){

                public void onServiceAdd(DiscoveryEvent discoveryEvent) {
                    System.out.println("Service added:" + discoveryEvent.getServiceName());
                    serviceLatch.countDown();
                }

                public void onServiceRemove(DiscoveryEvent discoveryEvent) {
                    System.out.println("Service removed:" + discoveryEvent.getServiceName());
                }
            });
            discoveryAgent.start();
            Assert.assertTrue((boolean)serviceLatch.await(15L, TimeUnit.MINUTES));
            System.out.println(MQFabricTest.executeCommand((String)"fabric:cluster-list"));
        }
        finally {
            curatorProxy.close();
        }
    }

    @Configuration
    public Option[] config() {
        return new Option[]{new DefaultCompositeOption(this.mqDistributionConfiguration()), KarafDistributionOption.keepRuntimeFolder(), KarafDistributionOption.logLevel((LogLevelOption.LogLevel)LogLevelOption.LogLevel.INFO)};
    }
}

