/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.arquillian.ajocado.locator.attribute;

import org.jboss.arquillian.ajocado.dom.Attribute;
import org.jboss.arquillian.ajocado.format.SimplifiedFormat;
import org.jboss.arquillian.ajocado.locator.AbstractLocator;
import org.jboss.arquillian.ajocado.locator.attribute.AttributeLocator;
import org.jboss.arquillian.ajocado.locator.element.ElementLocationStrategy;
import org.jboss.arquillian.ajocado.locator.element.ElementLocator;

public class DefaultAttributeLocator<E extends ElementLocator<E>>
extends AbstractLocator<AttributeLocator<E>>
implements AttributeLocator<E> {
    ElementLocator<E> elementLocator;
    Attribute attribute;

    public DefaultAttributeLocator(ElementLocator<E> elementLocator, Attribute attribute) {
        super("not-used");
        if (attribute == null) {
            throw new IllegalArgumentException("attribute can't be null");
        }
        this.elementLocator = elementLocator;
        this.attribute = attribute;
    }

    @Override
    public String getRawLocator() {
        return SimplifiedFormat.format("{0}@{1}", this.elementLocator.getRawLocator(), this.attribute.getAttributeName());
    }

    @Override
    public ElementLocationStrategy getLocationStrategy() {
        return this.elementLocator.getLocationStrategy();
    }

    @Override
    public ElementLocator<E> getAssociatedElement() {
        return this.elementLocator;
    }

    @Override
    public Attribute getAttribute() {
        return this.attribute;
    }

    @Override
    public AttributeLocator<E> format(Object ... args) {
        ElementLocator<E> derivedElementLocator = this.elementLocator.format(args);
        return new DefaultAttributeLocator<E>(derivedElementLocator, this.attribute);
    }
}

