/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.arquillian.ajocado.browser;

import java.io.File;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jboss.arquillian.ajocado.browser.BrowserMode;
import org.jboss.arquillian.ajocado.browser.BrowserType;
import org.jboss.arquillian.ajocado.selenium.SeleniumRepresentable;

public class Browser
implements SeleniumRepresentable {
    private static final Pattern PATTERN = Pattern.compile("^\\*([^\\s]+)(?:$|\\s+(.*))$");
    private static final int GROUP_MODE = 1;
    private static final int GROUP_EXECUTABLE = 2;
    private BrowserMode browserMode;
    private File executable;

    public Browser(String stringRepresentation) {
        Matcher matcher = PATTERN.matcher(stringRepresentation);
        if (!matcher.find()) {
            throw new IllegalArgumentException("given browser's stringRepresentation '" + stringRepresentation + "' doesn't match pattern");
        }
        this.browserMode = BrowserMode.parseMode(matcher.group(1));
        if (matcher.group(2) != null) {
            this.executable = new File(matcher.group(2));
        }
    }

    public Browser(BrowserMode browserMode) {
        this.browserMode = browserMode;
    }

    public Browser(BrowserMode browserMode, File executableFile) {
        this.browserMode = browserMode;
        this.executable = executableFile;
    }

    public BrowserMode getMode() {
        return this.browserMode;
    }

    public BrowserType getType() {
        if (this.browserMode == null) {
            return null;
        }
        return this.browserMode.getType();
    }

    @Override
    public String inSeleniumRepresentation() {
        StringBuilder builder = new StringBuilder(this.browserMode.inSeleniumRepresentation());
        if (this.executable != null) {
            builder.append(" ").append(this.executable.toString());
        }
        return builder.toString();
    }

    public String toString() {
        return "Browser [browserMode=" + this.browserMode + ", executable=" + this.executable + "]";
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.browserMode == null ? 0 : this.browserMode.hashCode());
        result = 31 * result + (this.executable == null ? 0 : this.executable.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Browser other = (Browser)obj;
        if (this.browserMode != other.browserMode) {
            return false;
        }
        return !(this.executable == null ? other.executable != null : !this.executable.equals(other.executable));
    }
}

