/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.arquillian.ajocado.guard.request;

import com.thoughtworks.selenium.SeleniumException;
import org.jboss.arquillian.ajocado.framework.AjaxSelenium;
import org.jboss.arquillian.ajocado.framework.AjaxSeleniumContext;
import org.jboss.arquillian.ajocado.framework.AjocadoConfiguration;
import org.jboss.arquillian.ajocado.framework.AjocadoConfigurationContext;
import org.jboss.arquillian.ajocado.guard.GuardedCommands;
import org.jboss.arquillian.ajocado.guard.request.RequestTypeGuardException;
import org.jboss.arquillian.ajocado.interception.CommandContext;
import org.jboss.arquillian.ajocado.interception.CommandInterceptionException;
import org.jboss.arquillian.ajocado.interception.CommandInterceptor;
import org.jboss.arquillian.ajocado.request.RequestType;

public class RequestTypeGuard
implements CommandInterceptor {
    private AjaxSelenium selenium = AjaxSeleniumContext.getProxy();
    private AjocadoConfiguration configuration = AjocadoConfigurationContext.getProxy();
    private RequestType requestExpected;
    private boolean interlayed;

    public RequestTypeGuard(RequestType requestExpected, boolean interlayed) {
        this.requestExpected = requestExpected;
        this.interlayed = interlayed;
    }

    public void intercept(CommandContext ctx) throws CommandInterceptionException {
        String command = ctx.getCommand();
        if (GuardedCommands.INTERACTIVE_COMMANDS.contains(command) || command.equals("getEval")) {
            this.doBeforeCommand();
        }
        ctx.invoke();
        if (GuardedCommands.INTERACTIVE_COMMANDS.contains(command) || command.equals("getEval")) {
            this.doAfterCommand();
        }
    }

    public void doBeforeCommand() {
        this.selenium.getPageExtensions().install();
        this.selenium.getRequestInterceptor().clearRequestTypeDone();
    }

    public void doAfterCommand() {
        long end = System.currentTimeMillis() + this.configuration.getTimeout(AjocadoConfiguration.TimeoutType.AJAX);
        RequestType lastRequestDone = RequestType.NONE;
        while (System.currentTimeMillis() <= end) {
            try {
                this.selenium.getRequestInterceptor().waitForRequestTypeChange();
            }
            catch (SeleniumException e) {
                System.out.println(e.getMessage());
            }
            RequestType requestDone = this.selenium.getRequestInterceptor().clearRequestTypeDone();
            if (requestDone == this.requestExpected) {
                lastRequestDone = requestDone;
                break;
            }
            if (this.interlayed) {
                if (requestDone == RequestType.HTTP) {
                    this.selenium.getPageExtensions().install();
                    this.selenium.getRequestInterceptor().clearRequestTypeDone();
                }
                if (requestDone == RequestType.NONE) continue;
                lastRequestDone = requestDone;
                continue;
            }
            lastRequestDone = requestDone;
            break;
        }
        if (lastRequestDone != this.requestExpected) {
            throw new RequestTypeGuardException(this.requestExpected, lastRequestDone);
        }
    }
}

