/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.arquillian.ajocado.interception;

import com.thoughtworks.selenium.CommandProcessor;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import org.jboss.arquillian.ajocado.interception.CommandContextImpl;
import org.jboss.arquillian.ajocado.interception.CommandInterceptionException;
import org.jboss.arquillian.ajocado.interception.CommandInterceptor;
import org.jboss.arquillian.ajocado.interception.InterceptionProxy;

public final class InterceptionProxyImpl
implements InterceptionProxy,
InvocationHandler {
    private Set<String> interceptedMethods = Collections.unmodifiableSet(new HashSet<String>(){
        {
            this.add("doCommand");
            this.add("getString");
            this.add("getBoolean");
            this.add("getNumber");
            this.add("getStringArray");
            this.add("getBooleanArray");
            this.add("getNumberArray");
        }
    });
    private CommandProcessor commandProcessor;
    private Map<Class<? extends CommandInterceptor>, CommandInterceptor> interceptors = new LinkedHashMap<Class<? extends CommandInterceptor>, CommandInterceptor>();

    public InterceptionProxyImpl(CommandProcessor commandProcessor) {
        this.commandProcessor = commandProcessor;
    }

    public CommandProcessor getCommandProcessorProxy() {
        return (CommandProcessor)Proxy.newProxyInstance(this.commandProcessor.getClass().getClassLoader(), this.commandProcessor.getClass().getInterfaces(), (InvocationHandler)this);
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        Object result;
        block7: {
            try {
                if (this.interceptedMethods.contains(method.getName())) {
                    String commandName = (String)args[0];
                    String[] arguments = (String[])args[1];
                    CommandContextImpl context = new CommandContextImpl(commandName, arguments, this.commandProcessor, method, this.interceptors.values());
                    try {
                        result = context.invoke();
                        break block7;
                    }
                    catch (CommandInterceptionException e) {
                        throw new IllegalStateException("There was at least one interceptor which didn't call invoke()");
                    }
                    catch (Exception e) {
                        throw new InvocationTargetException(e);
                    }
                }
                result = method.invoke((Object)this.commandProcessor, args);
            }
            catch (InvocationTargetException e) {
                throw e.getCause();
            }
            catch (Exception e) {
                throw new RuntimeException("unexpected invocation exception: " + e.getMessage());
            }
        }
        return result;
    }

    public void registerInterceptor(CommandInterceptor interceptor) {
        this.interceptors.put(interceptor.getClass(), interceptor);
    }

    public CommandInterceptor unregisterInterceptor(CommandInterceptor interceptor) {
        Class<? extends CommandInterceptor> typeToRemove = null;
        for (Map.Entry<Class<? extends CommandInterceptor>, CommandInterceptor> entry : this.interceptors.entrySet()) {
            if (!entry.getValue().equals(interceptor)) continue;
            typeToRemove = entry.getKey();
            break;
        }
        return this.interceptors.remove(typeToRemove);
    }

    public Set<CommandInterceptor> unregisterInterceptorType(Class<? extends CommandInterceptor> type) {
        LinkedHashSet<Class<? extends CommandInterceptor>> typesToRemove = new LinkedHashSet<Class<? extends CommandInterceptor>>();
        for (Class<? extends CommandInterceptor> entryType : this.interceptors.keySet()) {
            if (!entryType.isInstance(type)) continue;
            typesToRemove.add(entryType);
        }
        LinkedHashSet<CommandInterceptor> removedInterceptors = new LinkedHashSet<CommandInterceptor>();
        for (Class clazz : typesToRemove) {
            removedInterceptors.add(this.interceptors.remove(clazz));
        }
        return removedInterceptors;
    }

    public InterceptionProxyImpl immutableCopy() {
        InterceptionProxyImpl copy = new InterceptionProxyImpl(this.commandProcessor);
        copy.interceptors.putAll(this.interceptors);
        return copy;
    }
}

