/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.arquillian.ajocado.utils;

import java.io.IOException;
import java.io.InputStream;
import java.math.BigInteger;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import org.jboss.arquillian.ajocado.utils.SimplifiedFormat;

public final class URLUtils {
    private static final int MD5_BUFFER_SIZE = 8192;
    private static final int HEX_RADIX = 16;

    private URLUtils() {
    }

    public static URL buildUrl(String context, String ... relocations) {
        try {
            return URLUtils.buildUrl(new URL(context), relocations);
        }
        catch (MalformedURLException e) {
            throw new AssertionError((Object)SimplifiedFormat.format((String)"URL('{0}') isn't valid URL", (Object[])new Object[]{context}));
        }
    }

    public static URL buildUrl(URL context, String ... relocations) {
        URL url = context;
        for (String move : relocations) {
            try {
                url = new URL(url, move);
            }
            catch (MalformedURLException e) {
                throw new AssertionError((Object)SimplifiedFormat.format((String)"URL('{0}', '{1}') isn't valid URL", (Object[])new Object[]{url, move}));
            }
        }
        return url;
    }

    public static String resourceMd5Digest(String url) throws IOException {
        MessageDigest digest;
        URLConnection connection = new URL(url).openConnection();
        InputStream in = connection.getInputStream();
        try {
            digest = MessageDigest.getInstance("MD5");
        }
        catch (NoSuchAlgorithmException ex) {
            throw new IllegalStateException("MD5 hashing is unsupported", ex);
        }
        byte[] buffer = new byte[8192];
        int read = 0;
        while ((read = in.read(buffer)) > 0) {
            digest.update(buffer, 0, read);
        }
        byte[] md5sum = digest.digest();
        BigInteger bigInt = new BigInteger(1, md5sum);
        return bigInt.toString(16);
    }
}

