/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.arquillian.ajocado.waiting;

import org.jboss.arquillian.ajocado.waiting.WaitTimeoutException;
import org.jboss.arquillian.ajocado.waiting.Waiting;

public abstract class DefaultWaiting<T extends DefaultWaiting<T>>
implements Waiting<T>,
Cloneable {
    private boolean isDelayed = true;
    private long interval = 500L;
    private long timeout = 30000L;
    private Object failure = new WaitTimeoutException((CharSequence)"Waiting timed out", new Object[0]);
    private Object[] failureArgs;

    protected long getInterval() {
        return this.interval;
    }

    protected long getTimeout() {
        return this.timeout;
    }

    protected boolean isDelayed() {
        return this.isDelayed;
    }

    @Override
    public T interval(long interval) {
        if (interval == this.interval) {
            return (T)this;
        }
        T copy = this.copy();
        ((DefaultWaiting)copy).interval = interval;
        return copy;
    }

    @Override
    public T timeout(long timeout) {
        if (timeout == this.timeout) {
            return (T)this;
        }
        T copy = this.copy();
        ((DefaultWaiting)copy).timeout = timeout;
        return copy;
    }

    @Override
    public T failWith(Exception exception) {
        if (exception == null && this.failure == null) {
            return (T)this;
        }
        T copy = this.copy();
        ((DefaultWaiting)copy).failure = exception;
        ((DefaultWaiting)copy).failureArgs = null;
        return copy;
    }

    @Override
    public T failWith(CharSequence failureMessage, Object ... arguments) {
        T copy = this.copy();
        ((DefaultWaiting)copy).failure = failureMessage;
        ((DefaultWaiting)copy).failureArgs = arguments;
        return copy;
    }

    @Override
    public T dontFail() {
        return (T)this.failWith(null);
    }

    @Override
    public T noDelay() {
        return (T)this.withDelay(false);
    }

    @Override
    public T withDelay(boolean isDelayed) {
        if (isDelayed == this.isDelayed) {
            return (T)this;
        }
        T copy = this.copy();
        ((DefaultWaiting)copy).isDelayed = isDelayed;
        return copy;
    }

    @Override
    public void waitForTimeout() {
        try {
            Thread.sleep(this.timeout);
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
    }

    protected void fail() {
        if (this.failure != null) {
            throw this.prepareFailure();
        }
    }

    private RuntimeException prepareFailure() {
        if (this.failure instanceof RuntimeException) {
            return (RuntimeException)this.failure;
        }
        if (this.failure instanceof CharSequence) {
            return new WaitTimeoutException((CharSequence)this.failure, this.failureArgs);
        }
        return new WaitTimeoutException((Exception)this.failure);
    }

    private T copy() {
        try {
            return (T)((DefaultWaiting)this.clone());
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException(e);
        }
    }
}

