/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.arquillian.ajocado.framework;

import java.util.LinkedList;
import org.apache.commons.lang.StringUtils;
import org.jboss.arquillian.ajocado.css.CssProperty;
import org.jboss.arquillian.ajocado.framework.ExtendedSelenium;
import org.jboss.arquillian.ajocado.framework.ExtendedTypedSelenium;
import org.jboss.arquillian.ajocado.framework.TypedSeleniumImpl;
import org.jboss.arquillian.ajocado.geometry.Point;
import org.jboss.arquillian.ajocado.locator.AttributeLocator;
import org.jboss.arquillian.ajocado.locator.ElementLocationStrategy;
import org.jboss.arquillian.ajocado.locator.ElementLocator;
import org.jboss.arquillian.ajocado.locator.IterableLocator;

public class ExtendedTypedSeleniumImpl
extends TypedSeleniumImpl
implements ExtendedTypedSelenium {
    private boolean started = false;
    private boolean networkTrafficCapturingEnabled = false;

    protected ExtendedSelenium getExtendedSelenium() {
        if (this.selenium instanceof ExtendedSelenium) {
            return (ExtendedSelenium)this.selenium;
        }
        throw new UnsupportedOperationException("Assigned Selenium isn't instance of ExtendedSelenium");
    }

    public boolean isStarted() {
        return this.started;
    }

    @Override
    public void start() {
        LinkedList<String> parameters = new LinkedList<String>();
        if (this.networkTrafficCapturingEnabled) {
            parameters.add("captureNetworkTraffic=true");
        }
        this.selenium.start(StringUtils.join(parameters, (String)","));
        this.started = true;
    }

    @Override
    public void stop() {
        super.stop();
        this.started = false;
    }

    public void enableNetworkTrafficCapturing(boolean networkTrafficCapturingEnabled) {
        this.networkTrafficCapturingEnabled = networkTrafficCapturingEnabled;
    }

    public boolean isNetworkTrafficCapturingEnabled() {
        return this.networkTrafficCapturingEnabled;
    }

    public String getStyle(ElementLocator<?> elementLocator, String property) {
        return this.getExtendedSelenium().getStyle(elementLocator.getAsString(), property);
    }

    public String getStyle(ElementLocator<?> elementLocator, CssProperty property) {
        return this.getExtendedSelenium().getStyle(elementLocator.getAsString(), property.getPropertyName());
    }

    public void scrollIntoView(ElementLocator<?> elementLocator, boolean alignToTop) {
        this.getExtendedSelenium().scrollIntoView(elementLocator.getAsString(), String.valueOf(alignToTop));
    }

    public void mouseOverAt(ElementLocator<?> elementLocator, Point point) {
        this.getExtendedSelenium().mouseOverAt(elementLocator.getAsString(), point.getCoords());
    }

    public void mouseOutAt(ElementLocator<?> elementLocator, Point point) {
        this.getExtendedSelenium().mouseOutAt(elementLocator.getAsString(), point.getCoords());
    }

    public boolean isDisplayed(ElementLocator<?> elementLocator) {
        return this.getExtendedSelenium().isDisplayed(elementLocator.getAsString());
    }

    public boolean belongsClass(ElementLocator<?> elementLocator, String className) {
        return this.getExtendedSelenium().belongsClass(elementLocator.getAsString(), className);
    }

    public boolean isAttributePresent(AttributeLocator<?> attributeLocator) {
        String elementLocator = attributeLocator.getAssociatedElement().getAsString();
        String attributeName = attributeLocator.getAttribute().getAttributeName();
        return this.getExtendedSelenium().isAttributePresent(elementLocator, attributeName);
    }

    @Override
    public int getCount(IterableLocator<?> locator) {
        if (locator.getLocationStrategy() == ElementLocationStrategy.JQUERY) {
            return this.getExtendedSelenium().getJQueryCount(locator.getRawLocator()).intValue();
        }
        try {
            return super.getCount(locator);
        }
        catch (UnsupportedOperationException e) {
            throw new UnsupportedOperationException("Only JQuery and XPath locators are supported for counting");
        }
    }

    public void check(ElementLocator<?> locator, boolean checked) {
        if (checked) {
            this.check(locator);
        } else {
            this.uncheck(locator);
        }
    }

    public void doCommand(String command, String param1, String param2) {
        this.getExtendedSelenium().doCommand(command, param1, param2);
    }
}

