/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.arquillian.ajocado.framework.internal;

import java.util.List;
import org.apache.commons.lang.StringEscapeUtils;
import org.jboss.arquillian.ajocado.encapsulated.JavaScript;
import org.jboss.arquillian.ajocado.framework.AjaxSelenium;
import org.jboss.arquillian.ajocado.framework.AjaxSeleniumContext;
import org.jboss.arquillian.ajocado.framework.SeleniumExtensions;

public class SeleniumExtensionsImpl
implements SeleniumExtensions {
    AjaxSelenium selenium = AjaxSeleniumContext.getProxy();
    final JavaScript getScriptWithResourceName = JavaScript.fromResource((String)"javascript/get-script-with-resourcename.js");
    final JavaScript containsScriptWithResourceName = this.getScriptWithResourceName.append(" != null");
    final JavaScript getIdForScriptWithResourceName = this.getScriptWithResourceName.append(".getAttribute('id')");
    final JavaScript setResourceNameForId = JavaScript.js((String)"document.getElementById('{0}').setAttribute('resourceName', '{1}')");
    final JavaScript removeScript = JavaScript.js((String)"selenium.doRemoveScript('{0}')");

    public void requireResource(String resourceName) {
        if (!this.containsScript(resourceName)) {
            this.loadScript(resourceName);
        } else {
            this.refreshScript(resourceName);
        }
    }

    private boolean containsScript(String resourceName) {
        return Boolean.valueOf(this.selenium.getEval(this.containsScriptWithResourceName.parametrize(new Object[]{StringEscapeUtils.escapeJavaScript((String)resourceName)})));
    }

    private void loadScript(String resourceName) {
        JavaScript extension = JavaScript.fromResource((String)resourceName);
        String identification = extension.getIdentification();
        String escapedResourceName = StringEscapeUtils.escapeJavaScript((String)resourceName);
        this.selenium.addScript(extension);
        this.selenium.getEval(this.setResourceNameForId.parametrize(new Object[]{identification, escapedResourceName}));
    }

    private void refreshScript(String resourceName) {
        JavaScript extension = JavaScript.fromResource((String)resourceName);
        String identification = extension.getIdentification();
        String escapedResourceName = StringEscapeUtils.escapeJavaScript((String)resourceName);
        String scriptId = this.selenium.getEval(this.getIdForScriptWithResourceName.parametrize(new Object[]{escapedResourceName}));
        if (!scriptId.equals(identification)) {
            System.out.println("# Reloading extension: " + resourceName);
            this.selenium.getEval(this.removeScript.parametrize(new Object[]{scriptId}));
            this.loadScript(resourceName);
        }
    }

    public void requireResources(List<String> resourceNames) {
        for (String resourceName : resourceNames) {
            this.requireResource(resourceName);
        }
    }

    public void registerCustomHandlers() {
        JavaScript registerCustomHandlers = JavaScript.js((String)"currentTest.commandFactory.registerAll(selenium)");
        this.selenium.getEval(registerCustomHandlers);
    }
}

