/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.arquillian.ajocado.locator;

import org.apache.commons.lang.Validate;
import org.jboss.arquillian.ajocado.locator.LocationStrategy;
import org.jboss.arquillian.ajocado.locator.Locator;
import org.jboss.arquillian.ajocado.utils.SimplifiedFormat;

public abstract class AbstractLocator<T extends Locator<T>>
implements Locator<T> {
    private String locator;

    public AbstractLocator(String locator) {
        Validate.notNull((Object)locator);
        this.locator = locator;
    }

    public String getAsString() {
        LocationStrategy locationStrategy = this.getLocationStrategy();
        return SimplifiedFormat.format((String)"{0}={1}", (Object[])new Object[]{locationStrategy.getStrategyName(), this.getRawLocator()});
    }

    public String getRawLocator() {
        return this.locator;
    }

    public Locator<T> format(Object ... args) {
        String newLocator = SimplifiedFormat.format((String)this.locator, (Object[])args);
        try {
            return (Locator)this.getClass().getConstructor(String.class).newInstance(newLocator);
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
    }

    public String toString() {
        return this.getAsString();
    }
}

