/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.arquillian.ajocado.waiting.conditions;

import com.thoughtworks.selenium.SeleniumException;
import org.apache.commons.lang.StringEscapeUtils;
import org.apache.commons.lang.Validate;
import org.jboss.arquillian.ajocado.encapsulated.JavaScript;
import org.jboss.arquillian.ajocado.framework.AjaxSelenium;
import org.jboss.arquillian.ajocado.framework.AjaxSeleniumContext;
import org.jboss.arquillian.ajocado.utils.SimplifiedFormat;
import org.jboss.arquillian.ajocado.waiting.ajax.JavaScriptCondition;
import org.jboss.arquillian.ajocado.waiting.selenium.SeleniumCondition;

public class AlertEquals
implements SeleniumCondition,
JavaScriptCondition {
    private AjaxSelenium selenium = AjaxSeleniumContext.getProxy();
    private String message;

    protected AlertEquals() {
    }

    @Override
    public boolean isTrue() {
        Validate.notNull((Object)this.message);
        if (!this.selenium.isAlertPresent()) {
            return false;
        }
        String alertMessage = this.selenium.getAlert();
        if (!this.message.equals(alertMessage)) {
            throw new SeleniumException(SimplifiedFormat.format((String)"Alert has been displayed, but the message '{0}' doesn't equal to the expected '{1}'", (Object[])new Object[]{this.message, alertMessage}));
        }
        return true;
    }

    @Override
    public JavaScript getJavaScriptCondition() {
        Validate.notNull((Object)this.message);
        String escapedMessage = StringEscapeUtils.escapeJavaScript((String)this.message);
        return JavaScript.js((String)SimplifiedFormat.format((String)"selenium.isAlertPresent() && ((alertMessage = selenium.getAlert()) == '{0}' || selenium.throwError('Alert has been displayed, but the message \\'' + alertMessage + '\\' doesn\\'t equal to the expected \\'{0}\\''))", (Object[])new Object[]{escapedMessage}));
    }

    public static AlertEquals getInstance() {
        return new AlertEquals();
    }

    public AlertEquals message(String message) {
        Validate.notNull((Object)message);
        AlertEquals copy = this.copy();
        copy.message = message;
        return copy;
    }

    private AlertEquals copy() {
        AlertEquals copy = new AlertEquals();
        copy.message = this.message;
        return copy;
    }
}

