/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.arquillian.ajocado.waiting.conditions;

import org.apache.commons.lang.StringEscapeUtils;
import org.apache.commons.lang.Validate;
import org.jboss.arquillian.ajocado.encapsulated.JavaScript;
import org.jboss.arquillian.ajocado.framework.AjaxSelenium;
import org.jboss.arquillian.ajocado.framework.AjaxSeleniumContext;
import org.jboss.arquillian.ajocado.locator.AttributeLocator;
import org.jboss.arquillian.ajocado.utils.SimplifiedFormat;
import org.jboss.arquillian.ajocado.waiting.ajax.JavaScriptCondition;
import org.jboss.arquillian.ajocado.waiting.selenium.SeleniumCondition;

public class AttributeEquals
implements SeleniumCondition,
JavaScriptCondition {
    private AjaxSelenium selenium = AjaxSeleniumContext.getProxy();
    private AttributeLocator<?> attributeLocator;
    private String value;

    protected AttributeEquals() {
    }

    @Override
    public boolean isTrue() {
        Validate.notNull(this.attributeLocator);
        Validate.notNull((Object)this.value);
        return this.selenium.getAttribute(this.attributeLocator).equals(this.value);
    }

    @Override
    public JavaScript getJavaScriptCondition() {
        String escapedElementLocator = StringEscapeUtils.escapeJavaScript((String)this.attributeLocator.getAssociatedElement().getAsString());
        String escapedAttributeLocator = StringEscapeUtils.escapeJavaScript((String)this.attributeLocator.getAsString());
        String escapedValue = StringEscapeUtils.escapeJavaScript((String)this.value);
        return JavaScript.js((String)SimplifiedFormat.format((String)"selenium.isElementPresent('{0}') && (selenium.getAttribute('{1}') == '{2}')", (Object[])new Object[]{escapedElementLocator, escapedAttributeLocator, escapedValue}));
    }

    public static AttributeEquals getInstance() {
        return new AttributeEquals();
    }

    public AttributeEquals locator(AttributeLocator<?> attributeLocator) {
        Validate.notNull(attributeLocator);
        AttributeEquals copy = this.copy();
        copy.attributeLocator = attributeLocator;
        return copy;
    }

    public AttributeEquals text(String value) {
        Validate.notNull((Object)value);
        AttributeEquals copy = this.copy();
        copy.value = value;
        return copy;
    }

    private AttributeEquals copy() {
        AttributeEquals copy = new AttributeEquals();
        copy.attributeLocator = this.attributeLocator;
        copy.value = this.value;
        return copy;
    }
}

