/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.arquillian.ajocado.waiting.conditions;

import org.apache.commons.lang.StringEscapeUtils;
import org.apache.commons.lang.Validate;
import org.jboss.arquillian.ajocado.encapsulated.JavaScript;
import org.jboss.arquillian.ajocado.framework.AjaxSelenium;
import org.jboss.arquillian.ajocado.framework.AjaxSeleniumContext;
import org.jboss.arquillian.ajocado.locator.AttributeLocator;
import org.jboss.arquillian.ajocado.utils.SimplifiedFormat;
import org.jboss.arquillian.ajocado.waiting.ajax.JavaScriptCondition;
import org.jboss.arquillian.ajocado.waiting.selenium.SeleniumCondition;

public class AttributePresent
implements SeleniumCondition,
JavaScriptCondition {
    private AjaxSelenium selenium = AjaxSeleniumContext.getProxy();
    private AttributeLocator<?> attributeLocator;

    protected AttributePresent() {
    }

    @Override
    public boolean isTrue() {
        Validate.notNull(this.attributeLocator);
        return this.selenium.isAttributePresent(this.attributeLocator);
    }

    @Override
    public JavaScript getJavaScriptCondition() {
        String escapedElementLocator = StringEscapeUtils.escapeJavaScript((String)this.attributeLocator.getAssociatedElement().getAsString());
        String escapedAttributeName = StringEscapeUtils.escapeJavaScript((String)this.attributeLocator.getAttribute().getAttributeName());
        return JavaScript.js((String)SimplifiedFormat.format((String)"selenium.isAttributePresent('{0}', '{1}')", (Object[])new Object[]{escapedElementLocator, escapedAttributeName}));
    }

    public static AttributePresent getInstance() {
        return new AttributePresent();
    }

    public AttributePresent locator(AttributeLocator<?> attributeLocator) {
        Validate.notNull(attributeLocator);
        AttributePresent copy = this.copy();
        copy.attributeLocator = attributeLocator;
        return copy;
    }

    private AttributePresent copy() {
        AttributePresent copy = new AttributePresent();
        copy.attributeLocator = this.attributeLocator;
        return copy;
    }
}

