/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.arquillian.ajocado.waiting.conditions;

import org.apache.commons.lang.StringEscapeUtils;
import org.apache.commons.lang.Validate;
import org.jboss.arquillian.ajocado.encapsulated.JavaScript;
import org.jboss.arquillian.ajocado.framework.AjaxSelenium;
import org.jboss.arquillian.ajocado.framework.AjaxSeleniumContext;
import org.jboss.arquillian.ajocado.locator.ElementLocationStrategy;
import org.jboss.arquillian.ajocado.locator.IterableLocator;
import org.jboss.arquillian.ajocado.waiting.ajax.JavaScriptCondition;
import org.jboss.arquillian.ajocado.waiting.selenium.SeleniumCondition;

public class CountEquals
implements SeleniumCondition,
JavaScriptCondition {
    private AjaxSelenium selenium = AjaxSeleniumContext.getProxy();
    private IterableLocator<?> iterableLocator;
    private Integer count;

    protected CountEquals() {
    }

    @Override
    public boolean isTrue() {
        this.validate();
        return this.selenium.getCount(this.iterableLocator) == this.count.intValue();
    }

    @Override
    public JavaScript getJavaScriptCondition() {
        this.validate();
        String escapedRawLocator = StringEscapeUtils.escapeJavaScript((String)this.iterableLocator.getRawLocator());
        String countFunction = this.iterableLocator.getLocationStrategy() == ElementLocationStrategy.JQUERY ? "getJQueryCount" : "getXPathCount";
        return JavaScript.js((String)"selenium.{0}('{1}') == {2}").parametrize(new Object[]{countFunction, escapedRawLocator, this.count});
    }

    private void validate() {
        Validate.notNull(this.iterableLocator);
        Validate.notNull((Object)this.count);
    }

    public static CountEquals getInstance() {
        return new CountEquals();
    }

    public CountEquals locator(IterableLocator<?> iterableLocator) {
        Validate.notNull(iterableLocator);
        if (iterableLocator.getLocationStrategy() != ElementLocationStrategy.JQUERY && iterableLocator.getLocationStrategy() != ElementLocationStrategy.XPATH) {
            throw new IllegalArgumentException("Only XPath and JQuery locators are supported for counting");
        }
        CountEquals copy = this.copy();
        copy.iterableLocator = iterableLocator;
        return copy;
    }

    public CountEquals count(int count) {
        Validate.notNull((Object)count);
        CountEquals copy = this.copy();
        copy.count = count;
        return copy;
    }

    private CountEquals copy() {
        CountEquals copy = new CountEquals();
        copy.iterableLocator = this.iterableLocator;
        copy.count = this.count;
        return copy;
    }
}

