/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.arquillian.ajocado.waiting.conditions;

import org.apache.commons.lang.StringEscapeUtils;
import org.apache.commons.lang.Validate;
import org.jboss.arquillian.ajocado.encapsulated.JavaScript;
import org.jboss.arquillian.ajocado.framework.AjaxSelenium;
import org.jboss.arquillian.ajocado.framework.AjaxSeleniumContext;
import org.jboss.arquillian.ajocado.locator.ElementLocator;
import org.jboss.arquillian.ajocado.utils.SimplifiedFormat;
import org.jboss.arquillian.ajocado.waiting.ajax.JavaScriptCondition;
import org.jboss.arquillian.ajocado.waiting.selenium.SeleniumCondition;

public class IsNotDisplayed
implements SeleniumCondition,
JavaScriptCondition {
    private AjaxSelenium selenium = AjaxSeleniumContext.getProxy();
    private ElementLocator<?> elementLocator;

    protected IsNotDisplayed() {
    }

    @Override
    public boolean isTrue() {
        Validate.notNull(this.elementLocator);
        return !this.selenium.isDisplayed(this.elementLocator);
    }

    @Override
    public JavaScript getJavaScriptCondition() {
        String escapedLocator = StringEscapeUtils.escapeJavaScript((String)this.elementLocator.getAsString());
        return JavaScript.js((String)SimplifiedFormat.format((String)"!selenium.isDisplayed('{0}')", (Object[])new Object[]{escapedLocator}));
    }

    public static IsNotDisplayed getInstance() {
        return new IsNotDisplayed();
    }

    public IsNotDisplayed locator(ElementLocator<?> elementLocator) {
        Validate.notNull(elementLocator);
        IsNotDisplayed copy = this.copy();
        copy.elementLocator = elementLocator;
        return copy;
    }

    private IsNotDisplayed copy() {
        IsNotDisplayed copy = new IsNotDisplayed();
        copy.elementLocator = this.elementLocator;
        return copy;
    }
}

