/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.arquillian.ajocado.waiting.retrievers;

import org.apache.commons.lang.StringEscapeUtils;
import org.apache.commons.lang.Validate;
import org.jboss.arquillian.ajocado.encapsulated.JavaScript;
import org.jboss.arquillian.ajocado.framework.AjaxSelenium;
import org.jboss.arquillian.ajocado.framework.AjaxSeleniumContext;
import org.jboss.arquillian.ajocado.locator.AttributeLocator;
import org.jboss.arquillian.ajocado.utils.SimplifiedFormat;
import org.jboss.arquillian.ajocado.waiting.conversion.Convertor;
import org.jboss.arquillian.ajocado.waiting.conversion.PassOnConvertor;
import org.jboss.arquillian.ajocado.waiting.retrievers.AbstractRetriever;
import org.jboss.arquillian.ajocado.waiting.retrievers.Retriever;

public class AttributeRetriever
extends AbstractRetriever<String>
implements Retriever<String> {
    private AjaxSelenium selenium = AjaxSeleniumContext.getProxy();
    private AttributeLocator<?> attributeLocator;

    protected AttributeRetriever() {
    }

    @Override
    public String retrieve() {
        Validate.notNull(this.attributeLocator);
        return this.selenium.getAttribute(this.attributeLocator);
    }

    @Override
    public JavaScript getJavaScriptRetrieve() {
        String escapedLocator = StringEscapeUtils.escapeJavaScript((String)this.attributeLocator.getAsString());
        return JavaScript.js((String)SimplifiedFormat.format((String)"selenium.getAttribute('{0}')", (Object[])new Object[]{escapedLocator}));
    }

    public static AttributeRetriever getInstance() {
        return new AttributeRetriever();
    }

    public AttributeRetriever attributeLocator(AttributeLocator<?> attributeLocator) {
        Validate.notNull(attributeLocator);
        AttributeRetriever copy = this.copy();
        copy.attributeLocator = attributeLocator;
        return copy;
    }

    private AttributeRetriever copy() {
        AttributeRetriever copy = new AttributeRetriever();
        copy.attributeLocator = this.attributeLocator;
        return copy;
    }

    @Override
    public Convertor<String, String> getConvertor() {
        return new PassOnConvertor<String>();
    }
}

