/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.arquillian.ajocado.testng;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.EnumSet;
import java.util.List;
import org.apache.commons.io.IOUtils;
import org.jboss.arquillian.ajocado.browser.Browser;
import org.jboss.arquillian.ajocado.browser.BrowserMode;
import org.jboss.arquillian.ajocado.browser.BrowserType;
import org.jboss.arquillian.ajocado.encapsulated.JavaScript;
import org.jboss.arquillian.ajocado.framework.AjaxSelenium;
import org.jboss.arquillian.ajocado.framework.AjaxSeleniumContext;
import org.jboss.arquillian.ajocado.framework.AjaxSeleniumImpl;
import org.jboss.arquillian.ajocado.framework.AjocadoConfiguration;
import org.jboss.arquillian.ajocado.framework.AjocadoConfigurationContext;
import org.jboss.arquillian.ajocado.framework.SystemPropertiesConfiguration;
import org.jboss.arquillian.ajocado.locator.ElementLocationStrategy;
import org.jboss.arquillian.ajocado.utils.SimplifiedFormat;
import org.testng.SkipException;
import org.testng.annotations.AfterClass;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Optional;
import org.testng.annotations.Parameters;

public abstract class AbstractAjocadoTest {
    public static final int WAIT_GUI_INTERVAL = 100;
    public static final int WAIT_AJAX_INTERVAL = 500;
    public static final int WAIT_MODEL_INTERVAL = 1500;
    protected AjaxSelenium selenium;
    protected AjocadoConfiguration configuration = new SystemPropertiesConfiguration();
    protected URL contextRoot;
    protected URL contextPath;
    protected File buildDirectory;
    protected File resourcesDir;
    protected boolean seleniumDebug;
    protected Browser browser;

    @BeforeClass(alwaysRun=true)
    public void initializeParameters() throws MalformedURLException {
        AjocadoConfigurationContext.set((AjocadoConfiguration)this.configuration);
        this.seleniumDebug = this.configuration.isSeleniumDebug();
        this.contextRoot = this.configuration.getContextRoot();
        this.contextPath = this.configuration.getContextPath();
        this.resourcesDir = this.configuration.getResourcesDirectory();
        this.buildDirectory = this.configuration.getBuildDirectory();
        this.browser = this.configuration.getBrowser();
    }

    @BeforeClass(dependsOnMethods={"initializeParameters", "isTestBrowserEnabled"}, alwaysRun=true)
    public void initializeBrowser() {
        this.selenium = new AjaxSeleniumImpl(this.configuration.getSeleniumHost(), this.configuration.getSeleniumPort(), this.browser, this.contextPath);
        AjaxSeleniumContext.set((AjaxSelenium)this.selenium);
        this.selenium.enableNetworkTrafficCapturing(this.configuration.isSeleniumNetworkTrafficEnabled());
        this.selenium.start();
        this.loadCustomLocationStrategies();
        this.selenium.setSpeed((long)this.configuration.getSeleniumSpeed());
        if (this.configuration.isSeleniumMaximize()) {
            this.selenium.windowFocus();
            this.selenium.windowMaximize();
        }
    }

    public void restartBrowser() {
        this.finalizeBrowser();
        this.initializeBrowser();
        this.initializeExtensions();
    }

    @BeforeClass(alwaysRun=true, dependsOnMethods={"initializeBrowser"})
    public void initializeWaitTimeouts() {
        this.selenium.setTimeout(this.configuration.getTimeout(AjocadoConfiguration.TimeoutType.DEFAULT));
    }

    @BeforeClass(dependsOnMethods={"initializeBrowser"}, alwaysRun=true)
    public void initializeExtensions() {
        List<String> seleniumExtensions = this.getExtensionsListFromResource("javascript/selenium-extensions-order.txt");
        List<String> pageExtensions = this.getExtensionsListFromResource("javascript/page-extensions-order.txt");
        this.selenium.getSeleniumExtensions().requireResources(seleniumExtensions);
        this.selenium.getSeleniumExtensions().registerCustomHandlers();
        this.selenium.getPageExtensions().loadFromResources(pageExtensions);
    }

    private List<String> getExtensionsListFromResource(String resourceName) {
        try {
            return IOUtils.readLines((InputStream)ClassLoader.getSystemResourceAsStream(resourceName));
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
    }

    private void loadCustomLocationStrategies() {
        JavaScript strategySource = JavaScript.fromResource((String)"javascript/selenium-location-strategies/jquery-location-strategy.js");
        this.selenium.addLocationStrategy(ElementLocationStrategy.JQUERY, strategySource);
    }

    @AfterClass(alwaysRun=true)
    public void finalizeBrowser() {
        if (this.selenium != null && this.selenium.isStarted()) {
            this.selenium.deleteAllVisibleCookies();
            AjaxSeleniumContext.set(null);
            this.selenium.stop();
            this.selenium = null;
        }
    }

    @Parameters(value={"enabled-browsers", "disabled-browsers", "enabled-modes", "disabled-modes"})
    @BeforeClass(dependsOnMethods={"initializeParameters"}, alwaysRun=true)
    public void isTestBrowserEnabled(@Optional(value="*") String enabledBrowsersParam, @Optional(value="") String disabledBrowsersParam, @Optional(value="*") String enabledModesParam, @Optional(value="") String disabledModesParam) {
        EnumSet enabledBrowserTypes = BrowserType.parseTypes((String)enabledBrowsersParam);
        EnumSet disabledBrowserTypes = BrowserType.parseTypes((String)disabledBrowsersParam);
        EnumSet enabledBrowserModes = BrowserMode.parseModes((String)enabledModesParam);
        EnumSet disabledBrowserModes = BrowserMode.parseModes((String)disabledModesParam);
        enabledBrowserTypes.removeAll(disabledBrowserTypes);
        enabledBrowserModes.addAll(BrowserMode.getModesFromTypes((EnumSet)enabledBrowserTypes));
        enabledBrowserModes.removeAll(disabledBrowserModes);
        if (!enabledBrowserModes.contains(this.browser.getMode())) {
            throw new SkipException(SimplifiedFormat.format((String)"This test isn't supported in {0}", (Object[])new Object[]{this.browser}));
        }
    }
}

