/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.arquillian.ajocado.testng.listener;

import org.apache.commons.lang.StringUtils;
import org.jboss.arquillian.ajocado.framework.AjaxSelenium;
import org.jboss.arquillian.ajocado.framework.AjaxSeleniumContext;
import org.jboss.arquillian.ajocado.testng.utils.TestLoggingUtils;
import org.testng.ITestResult;
import org.testng.TestListenerAdapter;

public class SeleniumLoggingTestListener
extends TestListenerAdapter {
    private AjaxSelenium selenium = AjaxSeleniumContext.getProxy();

    public void onTestStart(ITestResult result) {
        this.logStatus(result);
    }

    public void onTestFailure(ITestResult result) {
        this.logStatus(result);
    }

    public void onTestSkipped(ITestResult result) {
        this.logStatus(result);
    }

    public void onTestSuccess(ITestResult result) {
        this.logStatus(result);
    }

    public void onTestFailedButWithinSuccessPercentage(ITestResult result) {
        this.logStatus(result);
    }

    private void logStatus(ITestResult result) {
        String hashes = "##########";
        String message = this.getMessage(result);
        String messageLine = String.format("%s %s %s", "##########", message, "##########");
        String line = StringUtils.repeat((String)"#", (int)messageLine.length());
        if (this.selenium.isStarted()) {
            String output = String.format("\n%s\n%s\n%s\n", line, messageLine, line);
            this.selenium.logToBrowser(output);
        }
    }

    protected String getMessage(ITestResult result) {
        return TestLoggingUtils.getTestDescription(result);
    }
}

