/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.arquillian.ajocado.testng;

import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Field;
import java.net.MalformedURLException;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import org.apache.commons.io.IOUtils;
import org.jboss.arquillian.ajocado.encapsulated.JavaScript;
import org.jboss.arquillian.ajocado.framework.AjaxSelenium;
import org.jboss.arquillian.ajocado.framework.AjaxSeleniumContext;
import org.jboss.arquillian.ajocado.framework.AjaxSeleniumImpl;
import org.jboss.arquillian.ajocado.framework.AjocadoConfiguration;
import org.jboss.arquillian.ajocado.framework.AjocadoConfigurationContext;
import org.jboss.arquillian.ajocado.framework.SystemPropertiesConfiguration;
import org.jboss.arquillian.ajocado.locator.ElementLocationStrategy;
import org.jboss.arquillian.ajocado.testng.listener.AbstractConfigurationListener;
import org.testng.ITestContext;
import org.testng.ITestNGMethod;
import org.testng.annotations.AfterClass;
import org.testng.annotations.BeforeClass;

public class AjocadoRunner
extends AbstractConfigurationListener {
    private static AjaxSelenium selenium = AjaxSeleniumContext.getProxy();
    private static ThreadLocal<Boolean> seleniumInitializedByMe = new BooleanThreadLocal();
    private static AjocadoConfiguration configuration = AjocadoConfigurationContext.getProxy();
    private static ThreadLocal<Boolean> configurationInitializedByMe = new BooleanThreadLocal();

    @BeforeClass(alwaysRun=true)
    public void initializeConfiguration() throws MalformedURLException {
        if (!AjocadoConfigurationContext.isInitialized()) {
            SystemPropertiesConfiguration newConfiguration = new SystemPropertiesConfiguration();
            AjocadoConfigurationContext.set((AjocadoConfiguration)newConfiguration);
            configurationInitializedByMe.set(true);
        }
    }

    @AfterClass(alwaysRun=true)
    public void finalizeConfiguration() {
        if (configurationInitializedByMe.get().booleanValue()) {
            AjocadoConfigurationContext.set(null);
            configurationInitializedByMe.set(false);
        }
    }

    @BeforeClass(dependsOnMethods={"initializeConfiguration"}, alwaysRun=true)
    public void initializeSelenium() {
        if (!AjaxSeleniumContext.isInitialized()) {
            AjaxSeleniumImpl newSelenium = new AjaxSeleniumImpl(configuration.getSeleniumHost(), configuration.getSeleniumPort(), configuration.getBrowser(), configuration.getContextPath());
            AjaxSeleniumContext.set((AjaxSelenium)newSelenium);
            seleniumInitializedByMe.set(true);
        }
    }

    @AfterClass(alwaysRun=true)
    public void finalizeSelenium() {
        if (seleniumInitializedByMe.get().booleanValue()) {
            AjaxSeleniumContext.set(null);
            seleniumInitializedByMe.set(false);
        }
    }

    @BeforeClass(alwaysRun=true, dependsOnMethods={"initializeSelenium"})
    public void injectContext(ITestContext context) {
        for (ITestNGMethod testNGMethod : context.getAllTestMethods()) {
            Object[] testInstances;
            for (Object testInstance : testInstances = testNGMethod.getInstances()) {
                for (Field field : AjocadoRunner.getAllSuperDeclaredFields(testInstance)) {
                    AjocadoRunner.tryInjectValue(testInstance, field, AjaxSelenium.class, selenium);
                    AjocadoRunner.tryInjectValue(testInstance, field, AjocadoConfiguration.class, configuration);
                }
            }
        }
    }

    @BeforeClass(alwaysRun=true, dependsOnMethods={"initializeSelenium"})
    public void initializeBrowser() {
        selenium.enableNetworkTrafficCapturing(configuration.isSeleniumNetworkTrafficEnabled());
        selenium.start();
        selenium.setSpeed((long)configuration.getSeleniumSpeed());
        if (configuration.isSeleniumMaximize()) {
            selenium.windowFocus();
            selenium.windowMaximize();
        }
    }

    public static void restartBrowser() {
        AjocadoRunner runner = new AjocadoRunner();
        runner.finalizeBrowser();
        runner.initializeBrowser();
        runner.initializeExtensions();
    }

    @AfterClass(alwaysRun=true)
    public void finalizeBrowser() {
        if (selenium.isStarted()) {
            selenium.deleteAllVisibleCookies();
            selenium.stop();
        }
    }

    @BeforeClass(dependsOnMethods={"initializeBrowser"}, alwaysRun=true)
    public void loadCustomLocationStrategies() {
        JavaScript strategySource = JavaScript.fromResource((String)"javascript/selenium-location-strategies/jquery-location-strategy.js");
        selenium.addLocationStrategy(ElementLocationStrategy.JQUERY, strategySource);
    }

    @BeforeClass(dependsOnMethods={"initializeBrowser"}, alwaysRun=true)
    public void initializeWaitTimeouts() {
        selenium.setTimeout(configuration.getTimeout(AjocadoConfiguration.TimeoutType.DEFAULT));
    }

    @BeforeClass(dependsOnMethods={"initializeBrowser"}, alwaysRun=true)
    public void initializeExtensions() {
        List<String> seleniumExtensions = AjocadoRunner.getExtensionsListFromResource("javascript/selenium-extensions-order.txt");
        List<String> pageExtensions = AjocadoRunner.getExtensionsListFromResource("javascript/page-extensions-order.txt");
        selenium.getSeleniumExtensions().requireResources(seleniumExtensions);
        selenium.getSeleniumExtensions().registerCustomHandlers();
        selenium.getPageExtensions().loadFromResources(pageExtensions);
    }

    private static List<String> getExtensionsListFromResource(String resourceName) {
        try {
            return IOUtils.readLines((InputStream)ClassLoader.getSystemResourceAsStream(resourceName));
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
    }

    private static <T> void tryInjectValue(Object testInstance, Field injectionField, Class<T> injectionType, T injectedValue) {
        try {
            if (injectionField.getType().isAssignableFrom(injectionType)) {
                Object currentValue;
                boolean accessible = injectionField.isAccessible();
                if (!accessible) {
                    injectionField.setAccessible(true);
                }
                if ((currentValue = injectionField.get(testInstance)) == null) {
                    injectionField.set(testInstance, injectedValue);
                }
                if (!accessible) {
                    injectionField.setAccessible(false);
                }
            }
        }
        catch (Exception e) {
            throw new IllegalStateException("Can't proceed injection of " + injectionType + " to " + injectionField, e);
        }
    }

    private static List<Field> getAllSuperDeclaredFields(Object object) {
        LinkedList<Field> fields = new LinkedList<Field>();
        for (Class<?> classT = object.getClass(); classT != null; classT = classT.getSuperclass()) {
            fields.addAll(Arrays.asList(classT.getDeclaredFields()));
        }
        return fields;
    }

    private static class BooleanThreadLocal
    extends ThreadLocal<Boolean> {
        private BooleanThreadLocal() {
        }

        @Override
        protected Boolean initialValue() {
            return false;
        }
    }
}

