/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.arquillian.ajocado.testng.listener;

import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import org.apache.commons.lang.ArrayUtils;
import org.jboss.arquillian.ajocado.testng.listener.ListenerThreadLocal;
import org.testng.IInvokedMethod;
import org.testng.IInvokedMethodListener;
import org.testng.ITestContext;
import org.testng.ITestNGListener;
import org.testng.ITestResult;
import org.testng.TestListenerAdapter;
import org.testng.annotations.AfterClass;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.AfterSuite;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.BeforeSuite;
import org.testng.annotations.Listeners;
import org.testng.annotations.Test;

public abstract class AbstractConfigurationListener
extends TestListenerAdapter
implements IInvokedMethodListener {
    private static final boolean DEBUG = Boolean.valueOf(System.getProperty("selenium.debug", "false"));
    private static final Class<?>[] CONFIGURATION_ORDER = new Class[]{BeforeSuite.class, BeforeClass.class, BeforeMethod.class, AfterMethod.class, AfterClass.class, AfterSuite.class};
    private static StringSetLocal configurationsSucceded = new StringSetLocal();
    private static StringSetLocal configurationsFailed = new StringSetLocal();
    private static StringSetLocal configurationsSkipped = new StringSetLocal();
    private static StringSetLocal methodsRunned = new StringSetLocal();
    private static Configurations configurations = new Configurations();
    private static ThreadLocalBoolean methodConfigurationsAdded = new ThreadLocalBoolean();
    private static ThreadLocalBoolean beforeSuiteConfigurationsAdded = new ThreadLocalBoolean();
    private static ThreadLocalBoolean afterSuiteConfigurationsAdded = new ThreadLocalBoolean();
    private static ListenerThreadLocal<Class<?>> lastRunnedClass = new ListenerThreadLocal();
    private static ListenerThreadLocal<ITestResult> testResult = new ListenerThreadLocal();
    private static ListenerThreadLocal<ITestContext> testContext = new ListenerThreadLocal();
    private Comparator<Class<?>> comparator = new Comparator<Class<?>>(){

        @Override
        public int compare(Class<?> o1, Class<?> o2) {
            if (o1 == o2) {
                return 0;
            }
            for (Class type : CONFIGURATION_ORDER) {
                if (o1 == type) {
                    return -1;
                }
                if (o2 != type) continue;
                return 1;
            }
            throw new IllegalStateException();
        }
    };

    public void onStart(ITestContext context) {
        this.setupContext(context);
    }

    public void onFinish(ITestContext context) {
        this.setupContext(context);
        if (lastRunnedClass.get(((Object)((Object)this)).getClass()) != null) {
            this.onClassFinish();
        }
        if (!((Boolean)afterSuiteConfigurationsAdded.get(((Object)((Object)this)).getClass())).booleanValue()) {
            this.introduceMethods(AfterSuite.class);
            afterSuiteConfigurationsAdded.set(((Object)((Object)this)).getClass(), true);
        }
        this.invokeMethods(AfterSuite.class);
    }

    public void onSuiteStart() {
        if (!((Boolean)beforeSuiteConfigurationsAdded.get(((Object)((Object)this)).getClass())).booleanValue()) {
            this.introduceMethods(BeforeSuite.class);
            beforeSuiteConfigurationsAdded.set(((Object)((Object)this)).getClass(), true);
        }
        this.invokeMethods(BeforeSuite.class);
    }

    public void onClassStart() {
        this.onSuiteStart();
        this.introduceMethods(BeforeClass.class, AfterClass.class);
        this.invokeMethods(BeforeClass.class);
    }

    public void onClassFinish() {
        this.invokeMethods(AfterClass.class);
        this.clearConfigurations();
    }

    public void onTestStart(ITestResult result) {
        this.checkClassChange(result);
        if (!this.isResultForThisListener(result)) {
            return;
        }
        this.setupContext(result);
        if (!((Boolean)methodConfigurationsAdded.get(((Object)((Object)this)).getClass())).booleanValue()) {
            this.introduceMethods(BeforeMethod.class, AfterMethod.class);
            methodConfigurationsAdded.set(((Object)((Object)this)).getClass(), true);
        }
        this.invokeMethods(BeforeMethod.class);
    }

    public void onTestFailedButWithinSuccessPercentage(ITestResult result) {
        if (!this.isResultForThisListener(result)) {
            return;
        }
        this.setupContext(result);
        ((Set)methodsRunned.get(((Object)((Object)this)).getClass())).add(result.getMethod().getMethodName());
        this.invokeMethods(AfterMethod.class);
    }

    public void onTestFailure(ITestResult result) {
        if (!this.isResultForThisListener(result)) {
            return;
        }
        this.setupContext(result);
        ((Set)methodsRunned.get(((Object)((Object)this)).getClass())).add(result.getMethod().getMethodName());
        this.invokeMethods(AfterMethod.class);
    }

    public void onTestSkipped(ITestResult result) {
        if (!this.isResultForThisListener(result)) {
            return;
        }
        this.setupContext(result);
        ((Set)methodsRunned.get(((Object)((Object)this)).getClass())).add(result.getMethod().getMethodName());
        this.invokeMethods(AfterMethod.class);
    }

    public void onTestSuccess(ITestResult result) {
        if (!this.isResultForThisListener(result)) {
            return;
        }
        this.setupContext(result);
        ((Set)methodsRunned.get(((Object)((Object)this)).getClass())).add(result.getMethod().getMethodName());
        this.invokeMethods(AfterMethod.class);
    }

    public void onConfigurationSuccess(ITestResult result) {
        if (!this.isResultForThisListener(result)) {
            return;
        }
        if (DEBUG) {
            System.out.println("#" + result.getMethod().getMethodName());
        }
        ((Set)configurationsSucceded.get(((Object)((Object)this)).getClass())).add(result.getMethod().getMethodName());
    }

    public void onConfigurationFailure(ITestResult result) {
        if (!this.isResultForThisListener(result)) {
            return;
        }
        if (DEBUG) {
            System.out.println("#" + result.getMethod().getMethodName());
        }
        ((Set)configurationsFailed.get(((Object)((Object)this)).getClass())).add(result.getMethod().getMethodName());
    }

    public void onConfigurationSkip(ITestResult result) {
        if (!this.isResultForThisListener(result)) {
            return;
        }
        if (DEBUG) {
            System.out.println("#" + result.getMethod().getMethodName());
        }
        ((Set)configurationsSkipped.get(((Object)((Object)this)).getClass())).add(result.getMethod().getMethodName());
    }

    private void checkClassChange(ITestResult result) {
        if (AbstractConfigurationListener.getRealClassFromTestResult(result) != lastRunnedClass.get(((Object)((Object)this)).getClass()) && lastRunnedClass.get(((Object)((Object)this)).getClass()) != null) {
            this.onClassFinish();
        }
        if (!this.isResultForThisListener(result)) {
            return;
        }
        if (AbstractConfigurationListener.getRealClassFromTestResult(result) != lastRunnedClass.get(((Object)((Object)this)).getClass())) {
            this.setupContext(result);
            this.onClassStart();
            lastRunnedClass.set(((Object)((Object)this)).getClass(), AbstractConfigurationListener.getRealClassFromTestResult(result));
        }
    }

    private static Class<?> getRealClassFromTestResult(ITestResult testResult) {
        return testResult.getInstance().getClass();
    }

    public void beforeInvocation(IInvokedMethod method, ITestResult result) {
        AfterMethod afterMethod;
        AfterClass afterClass;
        this.checkClassChange(result);
        if (!this.isResultForThisListener(result)) {
            return;
        }
        this.setupContext(result);
        BeforeClass beforeClass = method.getTestMethod().getMethod().getAnnotation(BeforeClass.class);
        if (beforeClass != null) {
            this.setupContext(new Object[0]);
            this.invokeMethods(BeforeClass.class);
        }
        if ((afterClass = method.getTestMethod().getMethod().getAnnotation(AfterClass.class)) != null) {
            this.invokeMethods(AfterClass.class);
        }
        BeforeMethod beforeMethod = method.getTestMethod().getMethod().getAnnotation(BeforeMethod.class);
        Test testMethod = method.getTestMethod().getMethod().getAnnotation(Test.class);
        if (beforeMethod != null || testMethod != null) {
            if (!((Boolean)methodConfigurationsAdded.get(((Object)((Object)this)).getClass())).booleanValue()) {
                this.introduceMethods(BeforeMethod.class, AfterMethod.class);
                methodConfigurationsAdded.set(((Object)((Object)this)).getClass(), true);
            }
            this.invokeMethods(BeforeMethod.class);
        }
        if ((afterMethod = method.getTestMethod().getMethod().getAnnotation(AfterMethod.class)) != null) {
            this.invokeMethods(AfterMethod.class);
        }
    }

    public void afterInvocation(IInvokedMethod method, ITestResult result) {
        BeforeMethod beforeMethod;
        AfterClass afterClass;
        BeforeClass beforeClass;
        if (!this.isResultForThisListener(result)) {
            return;
        }
        this.setupContext(result);
        if (method.isTestMethod()) {
            methodConfigurationsAdded.set(((Object)((Object)this)).getClass(), false);
        }
        if ((beforeClass = method.getTestMethod().getMethod().getAnnotation(BeforeClass.class)) != null) {
            this.setupContext(new Object[0]);
            this.invokeMethods(BeforeClass.class);
        }
        if ((afterClass = method.getTestMethod().getMethod().getAnnotation(AfterClass.class)) != null) {
            this.invokeMethods(AfterClass.class);
        }
        if ((beforeMethod = method.getTestMethod().getMethod().getAnnotation(BeforeMethod.class)) != null) {
            this.setupContext(new Object[0]);
            this.invokeMethods(BeforeMethod.class);
        }
        AfterMethod afterMethod = method.getTestMethod().getMethod().getAnnotation(AfterMethod.class);
        Test testMethod = method.getTestMethod().getMethod().getAnnotation(Test.class);
        if (afterMethod != null || testMethod != null) {
            this.invokeMethods(AfterMethod.class);
        }
    }

    public String toString() {
        return ((Object)((Object)this)).getClass().getSimpleName();
    }

    private void invokeMethods(Class<? extends Annotation> ... typesToInvoke) {
        if (!this.isResultForThisListener(testResult.get(((Object)((Object)this)).getClass()))) {
            return;
        }
        TreeSet<ConfigurationMethod> configurationsToRemove = new TreeSet<ConfigurationMethod>();
        for (ConfigurationMethod configuration : (SortedSet)configurations.get(((Object)((Object)this)).getClass())) {
            if (!this.tryInvoke(configuration.method, configuration.annotation, typesToInvoke)) continue;
            configurationsToRemove.add(configuration);
        }
        for (ConfigurationMethod configuration : configurationsToRemove) {
            ((SortedSet)configurations.get(((Object)((Object)this)).getClass())).remove(configuration);
        }
    }

    private boolean isResultForThisListener(ITestResult testResult) {
        if (testResult != null) {
            Class<?> testInstanceClass = testResult.getInstance().getClass();
            for (Class<? extends ITestNGListener> listenerType : this.getAllListenerTypesForClass(testInstanceClass)) {
                if (listenerType != ((Object)((Object)this)).getClass()) continue;
                return true;
            }
            return false;
        }
        return true;
    }

    private List<Class<? extends ITestNGListener>> getAllListenerTypesForClass(Class<?> type) {
        LinkedList<Class<? extends ITestNGListener>> list = new LinkedList<Class<? extends ITestNGListener>>();
        while (type != Object.class) {
            Listeners annotation = type.getAnnotation(Listeners.class);
            if (annotation != null) {
                list.addAll(Arrays.asList(annotation.value()));
            }
            type = type.getSuperclass();
        }
        return list;
    }

    private boolean tryInvoke(Method method, Annotation annotation, Class<? extends Annotation>[] typesToInvoke) {
        Class<? extends Annotation> type = annotation.annotationType();
        if (!ArrayUtils.contains((Object[])typesToInvoke, annotation.annotationType())) {
            return false;
        }
        boolean invoke = true;
        for (String dependency : this.getMethodDependencies(annotation)) {
            if (this.getMethodAlwaysRun(annotation)) {
                invoke &= ((Set)configurationsSucceded.get(((Object)((Object)this)).getClass())).contains(dependency) || ((Set)configurationsSkipped.get(((Object)((Object)this)).getClass())).contains(dependency) || ((Set)configurationsFailed.get(((Object)((Object)this)).getClass())).contains(dependency);
                continue;
            }
            invoke &= ((Set)configurationsSucceded.get(((Object)((Object)this)).getClass())).contains(dependency);
        }
        if (invoke &= AfterMethod.class != type || testResult.get(((Object)((Object)this)).getClass()).isSuccess() || this.getMethodAlwaysRun(annotation)) {
            this.invokeMethod(method);
            return true;
        }
        return false;
    }

    private void invokeMethod(Method method) {
        Object[] parameters = new Object[method.getParameterTypes().length];
        for (int i = 0; i < method.getParameterTypes().length; ++i) {
            Class<?> parameterType = method.getParameterTypes()[i];
            if (parameterType == ITestResult.class) {
                parameters[i] = testResult.get(((Object)((Object)this)).getClass());
                continue;
            }
            if (parameterType == ITestContext.class) {
                parameters[i] = testContext.get(((Object)((Object)this)).getClass());
                continue;
            }
            throw new IllegalArgumentException();
        }
        try {
            if (DEBUG) {
                System.out.println("%" + method.getName());
            }
            method.invoke((Object)this, parameters);
            ((Set)configurationsSucceded.get(((Object)((Object)this)).getClass())).add(method.getName());
        }
        catch (IllegalArgumentException e) {
            e.printStackTrace();
            throw new IllegalStateException(e);
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
            throw new IllegalStateException(e);
        }
        catch (InvocationTargetException e) {
            e.getCause().printStackTrace();
            ((Set)configurationsFailed.get(((Object)((Object)this)).getClass())).add(method.getName());
        }
    }

    private void setupContext(Object ... contextParams) {
        testResult.set(((Object)((Object)this)).getClass(), null);
        for (Object contextParam : contextParams) {
            if (contextParam instanceof ITestResult) {
                testResult.set(((Object)((Object)this)).getClass(), (ITestResult)contextParam);
                continue;
            }
            if (!(contextParam instanceof ITestContext)) continue;
            testContext.set(((Object)((Object)this)).getClass(), (ITestContext)contextParam);
        }
    }

    private void clearConfigurations() {
        ((Set)configurationsSucceded.get(((Object)((Object)this)).getClass())).clear();
        ((Set)configurationsFailed.get(((Object)((Object)this)).getClass())).clear();
        ((Set)configurationsSkipped.get(((Object)((Object)this)).getClass())).clear();
        ((Set)methodsRunned.get(((Object)((Object)this)).getClass())).clear();
        ((SortedSet)configurations.get(((Object)((Object)this)).getClass())).clear();
        methodConfigurationsAdded.set(((Object)((Object)this)).getClass(), false);
    }

    private void introduceMethods(Class<? extends Annotation> ... annotations) {
        for (Method method : ((Object)((Object)this)).getClass().getMethods()) {
            for (Class<? extends Annotation> annotationType : annotations) {
                Annotation annotation = method.getAnnotation(annotationType);
                this.introduceAnnotatedMethod(method, annotation);
            }
        }
    }

    private void introduceAnnotatedMethod(Method method, Annotation annotation) {
        if (annotation != null) {
            ConfigurationMethod configuration = new ConfigurationMethod(method, annotation);
            ((SortedSet)configurations.get(((Object)((Object)this)).getClass())).add(configuration);
        }
    }

    private String[] getMethodDependencies(Annotation annotation) {
        return (String[])this.getMethodProperty(annotation, ConfigurationProperty.dependsOnMethods);
    }

    private boolean getMethodAlwaysRun(Annotation annotation) {
        return (Boolean)this.getMethodProperty(annotation, ConfigurationProperty.alwaysRun);
    }

    private Object getMethodProperty(Annotation annotation, ConfigurationProperty configurationProperty) {
        try {
            return annotation.getClass().getMethod(configurationProperty.toString(), new Class[0]).invoke((Object)annotation, new Object[0]);
        }
        catch (IllegalArgumentException e) {
            throw new IllegalStateException(e);
        }
        catch (SecurityException e) {
            throw new IllegalStateException(e);
        }
        catch (IllegalAccessException e) {
            throw new IllegalStateException(e);
        }
        catch (InvocationTargetException e) {
            throw new IllegalStateException(e);
        }
        catch (NoSuchMethodException e) {
            throw new IllegalStateException(e);
        }
    }

    private class ConfigurationMethod
    implements Comparable<ConfigurationMethod> {
        private Method method;
        private Annotation annotation;

        public ConfigurationMethod(Method method, Annotation annotation) {
            this.method = method;
            this.annotation = annotation;
        }

        @Override
        public int compareTo(ConfigurationMethod o) {
            int result = AbstractConfigurationListener.this.comparator.compare(this.annotation.annotationType(), o.annotation.annotationType());
            if (result != 0) {
                return result;
            }
            if (ArrayUtils.contains((Object[])AbstractConfigurationListener.this.getMethodDependencies(this.annotation), (Object)o.method.getName())) {
                return 1;
            }
            if (ArrayUtils.contains((Object[])AbstractConfigurationListener.this.getMethodDependencies(o.annotation), (Object)this.method.getName())) {
                if (result != 0) {
                    throw new IllegalStateException("Cyclic dependency found");
                }
                return -1;
            }
            if (result == 0) {
                result = this.method.getName().compareTo(o.method.getName());
            }
            if (result == 0) {
                result = this.annotation.annotationType().getCanonicalName().compareTo(o.annotation.annotationType().getCanonicalName());
            }
            return result;
        }

        public String toString() {
            return this.method.getName() + " (" + this.annotation.annotationType().getSimpleName() + ")";
        }
    }

    private static class StringSetLocal
    extends ListenerThreadLocal<Set<String>> {
        private StringSetLocal() {
        }

        @Override
        protected Set<String> initialValue() {
            return new TreeSet<String>();
        }
    }

    private static enum ConfigurationProperty {
        alwaysRun,
        dependsOnMethods;

    }

    private static class ThreadLocalBoolean
    extends ListenerThreadLocal<Boolean> {
        private ThreadLocalBoolean() {
        }

        @Override
        protected Boolean initialValue() {
            return Boolean.FALSE;
        }
    }

    private static class Configurations
    extends ListenerThreadLocal<SortedSet<ConfigurationMethod>> {
        private Configurations() {
        }

        @Override
        protected SortedSet<ConfigurationMethod> initialValue() {
            return new TreeSet<ConfigurationMethod>();
        }
    }
}

