/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.arquillian.ajocado.testng.utils;

import java.util.Date;
import org.jboss.arquillian.ajocado.testng.utils.TestInfo;
import org.testng.ITestResult;

public final class TestLoggingUtils {
    private TestLoggingUtils() {
    }

    public static String getTestDescription(ITestResult result) {
        String methodName = TestInfo.getPackageClassMethodName(result);
        String status = TestInfo.STATUSES.get(result.getStatus());
        StringBuilder parameters = new StringBuilder("(");
        if (result.getParameters() != null && result.getParameters().length != 0) {
            for (int i = 0; i < result.getParameters().length; ++i) {
                parameters.append("\"");
                parameters.append(result.getParameters()[i]);
                parameters.append(i == result.getParameters().length - 1 ? "\"" : "\", ");
            }
        }
        parameters.append(")");
        String message = String.format("[%tT] %s: %s%s", new Date(), status.toUpperCase(), methodName, parameters.toString());
        return message;
    }
}

