/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.arquillian.impl;

import org.jboss.arquillian.impl.ClientDeploymentGenerator;
import org.jboss.arquillian.impl.Deployer;
import org.jboss.arquillian.impl.DeploymentGenerator;
import org.jboss.arquillian.impl.NullDeploymentGenerator;
import org.jboss.arquillian.impl.Validate;
import org.jboss.arquillian.impl.container.Controlable;
import org.jboss.arquillian.spi.ServiceLoader;
import org.jboss.shrinkwrap.api.Archive;

public class DeployableTest {
    private static boolean inContainer = false;
    private Controlable containerController;
    private Deployer containerDeployer;
    private ServiceLoader serviceLoader;

    public static boolean isInContainer() {
        return inContainer;
    }

    public static void setInContainer(boolean inContainer) {
        DeployableTest.inContainer = inContainer;
    }

    DeployableTest(Controlable containerController, Deployer containerDeployer, ServiceLoader serviceLoader) {
        Validate.notNull(containerController, "ContainerController must bespecified");
        Validate.notNull(containerDeployer, "ContainerDeployer must bespecified");
        Validate.notNull(serviceLoader, "ServiceLoader must bespecified");
        this.containerController = containerController;
        this.containerDeployer = containerDeployer;
        this.serviceLoader = serviceLoader;
    }

    public Controlable getContainerController() {
        return this.containerController;
    }

    public Deployer getDeployer() {
        return this.containerDeployer;
    }

    public Archive<?> generateArchive(Class<?> testCase) {
        return this.getArchiveGenerator().generate(testCase);
    }

    private DeploymentGenerator getArchiveGenerator() {
        if (DeployableTest.isInContainer()) {
            return new NullDeploymentGenerator();
        }
        return new ClientDeploymentGenerator(this.serviceLoader);
    }
}

