/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.arquillian.impl;

import org.jboss.arquillian.impl.DeployableTest;
import org.jboss.arquillian.impl.Deployer;
import org.jboss.arquillian.impl.DynamicServiceLoader;
import org.jboss.arquillian.impl.TestResultImpl;
import org.jboss.arquillian.impl.container.ContainerController;
import org.jboss.arquillian.impl.container.ContainerDeployer;
import org.jboss.arquillian.impl.container.Controlable;
import org.jboss.arquillian.spi.ContainerMethodExecutor;
import org.jboss.arquillian.spi.DeployableContainer;
import org.jboss.arquillian.spi.DeploymentException;
import org.jboss.arquillian.spi.LifecycleException;
import org.jboss.arquillian.spi.TestMethodExecutor;
import org.jboss.arquillian.spi.TestResult;
import org.jboss.arquillian.spi.util.TestEnrichers;
import org.jboss.shrinkwrap.api.Archive;

public class DeployableTestBuilder {
    private DeployableTestBuilder() {
    }

    public static DeployableTest build(Object config) {
        Controlable controller = null;
        Deployer deployer = null;
        DynamicServiceLoader serviceLoader = new DynamicServiceLoader();
        if (DeployableTest.isInContainer()) {
            controller = new InContainerContainer();
            deployer = new InContainerContainer();
        } else {
            DeployableContainer container = (DeployableContainer)serviceLoader.onlyOne(DeployableContainer.class);
            controller = new ContainerController(container);
            deployer = new ContainerDeployer(container);
        }
        return new DeployableTest(controller, deployer, serviceLoader);
    }

    private static class InContainerContainer
    implements Controlable,
    Deployer {
        private InContainerContainer() {
        }

        @Override
        public void start() throws LifecycleException {
        }

        @Override
        public void stop() throws LifecycleException {
        }

        @Override
        public ContainerMethodExecutor deploy(Archive<?> archive) throws DeploymentException {
            return new ContainerMethodExecutor(){

                public TestResult invoke(TestMethodExecutor testMethodExecutor) {
                    try {
                        TestEnrichers.enrich((Object)testMethodExecutor.getInstance());
                        testMethodExecutor.invoke();
                        return new TestResultImpl(TestResult.Status.PASSED);
                    }
                    catch (Throwable e) {
                        return new TestResultImpl(TestResult.Status.FAILED, e);
                    }
                }
            };
        }

        @Override
        public void undeploy(Archive<?> archive) throws DeploymentException {
        }
    }
}

