/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.arquillian.impl;

import java.lang.reflect.Method;
import org.jboss.arquillian.api.Deployment;
import org.jboss.arquillian.impl.Validate;
import org.jboss.arquillian.spi.ApplicationArchiveGenerator;
import org.jboss.shrinkwrap.api.Archive;
import org.jboss.shrinkwrap.api.container.ClassContainer;

public class DeploymentAnnotationArchiveGenerator
implements ApplicationArchiveGenerator {
    public Archive<?> generateApplicationArchive(Class<?> testCase) {
        Validate.notNull(testCase, "TestCase must be specified");
        Method deploymentMethod = DeploymentAnnotationArchiveGenerator.findDeploymentMethod(testCase);
        if (deploymentMethod == null) {
            throw new RuntimeException("No static method annotated with " + Deployment.class.getName() + " found");
        }
        try {
            Archive archive = (Archive)deploymentMethod.invoke(null, new Object[0]);
            if (ClassContainer.class.isInstance(archive)) {
                ClassContainer classContainer = (ClassContainer)ClassContainer.class.cast(archive);
                classContainer.addClass(testCase);
            }
            return archive;
        }
        catch (Exception e) {
            throw new RuntimeException("Could not get Deployment", e);
        }
    }

    private static Method findDeploymentMethod(Class<?> testCase) {
        Method[] methods;
        for (Method method : methods = testCase.getMethods()) {
            if (!method.isAnnotationPresent(Deployment.class)) continue;
            return method;
        }
        return null;
    }
}

