/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.arquillian.impl;

import junit.framework.Assert;
import org.jboss.arquillian.api.Deployment;
import org.jboss.arquillian.impl.DeploymentAnnotationArchiveGenerator;
import org.jboss.shrinkwrap.api.Archive;
import org.jboss.shrinkwrap.api.ArchivePath;
import org.jboss.shrinkwrap.api.ArchivePaths;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.spec.JavaArchive;
import org.jboss.shrinkwrap.api.spec.ResourceAdapterArchive;
import org.junit.Test;

public class DeploymentAnnotationArchiveGeneratorTestCase {
    @Test(expected=IllegalArgumentException.class)
    public void shouldThrowExceptionOnDeploymentNotPresent() throws Exception {
        new DeploymentAnnotationArchiveGenerator().generateApplicationArchive(DeploymentNotPresent.class);
    }

    @Test(expected=IllegalArgumentException.class)
    public void shouldThrowExceptionOnDeploymentNotStatic() throws Exception {
        new DeploymentAnnotationArchiveGenerator().generateApplicationArchive(DeploymentNotStatic.class);
    }

    @Test(expected=IllegalArgumentException.class)
    public void shouldThrowExceptionOnDeploymentWrongReturnType() throws Exception {
        new DeploymentAnnotationArchiveGenerator().generateApplicationArchive(DeploymentWrongReturnType.class);
    }

    @Test
    public void shouldThrowExceptionOnDeploymentOk() throws Exception {
        Archive archive = new DeploymentAnnotationArchiveGenerator().generateApplicationArchive(DeploymentOK.class);
        ArchivePath testPath = ArchivePaths.create((String)(DeploymentOK.class.getName().replaceAll("\\.", "/") + ".class"));
        Assert.assertNotNull((Object)archive.contains(testPath));
    }

    @Test
    public void shouldNotIncludeTheTestClassIfClassesNotSupportedByTheArchive() throws Exception {
        Archive archive = new DeploymentAnnotationArchiveGenerator().generateApplicationArchive(DeploymentClassesNotSupported.class);
        Assert.assertTrue((boolean)archive.getContent().isEmpty());
    }

    private static class DeploymentClassesNotSupported {
        private DeploymentClassesNotSupported() {
        }

        @Deployment
        public static ResourceAdapterArchive test() {
            return (ResourceAdapterArchive)ShrinkWrap.create((String)"test.jar", ResourceAdapterArchive.class);
        }
    }

    private static class DeploymentOK {
        private DeploymentOK() {
        }

        @Deployment
        public static JavaArchive test() {
            return (JavaArchive)ShrinkWrap.create((String)"test.jar", JavaArchive.class);
        }
    }

    private static class DeploymentWrongReturnType {
        private DeploymentWrongReturnType() {
        }

        @Deployment
        public Object test() {
            return ShrinkWrap.create((String)"test.jar", JavaArchive.class);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class DeploymentNotStatic {
        private DeploymentNotStatic() {
        }

        @Deployment
        public Archive<?> test() {
            return (Archive)ShrinkWrap.create((String)"test.jar", JavaArchive.class);
        }
    }

    private static class DeploymentNotPresent {
        private DeploymentNotPresent() {
        }
    }
}

