/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.arquillian.impl;

import java.util.Collection;
import org.jboss.arquillian.impl.DynamicServiceLoader;
import org.junit.Assert;
import org.junit.Test;

public class DynamicServiceLoaderTestCase {
    @Test(expected=IllegalStateException.class)
    public void shouldFailIfMultipleProvidersFound() throws Exception {
        new DynamicServiceLoader().onlyOne(Service.class);
    }

    @Test
    public void shouldNotFailIfMultipleProvidersFoundPointingToSameImpl() throws Exception {
        Service2 service = (Service2)new DynamicServiceLoader().onlyOne(Service2.class);
        Assert.assertTrue((String)"verify that a instance of Service2Impl was loaded", (service.getClass() == Service2Impl.class ? 1 : 0) != 0);
    }

    @Test
    public void shouldLoadAllInstances() throws Exception {
        Collection services = new DynamicServiceLoader().all(Service.class);
        Assert.assertEquals((String)"verify that all services where found and loaded", (long)2L, (long)services.size());
    }

    public static class Service2Impl
    implements Service2 {
    }

    public static interface Service2 {
    }

    public static class ServiceImpl2
    implements Service {
    }

    public static class ServiceImpl1
    implements Service {
    }

    public static interface Service {
    }
}

