/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.arquillian.impl.handler;

import junit.framework.Assert;
import org.jboss.arquillian.impl.context.ClassContext;
import org.jboss.arquillian.impl.context.SuiteContext;
import org.jboss.arquillian.impl.handler.ContainerDeployer;
import org.jboss.arquillian.spi.ContainerMethodExecutor;
import org.jboss.arquillian.spi.Context;
import org.jboss.arquillian.spi.DeployableContainer;
import org.jboss.arquillian.spi.ServiceLoader;
import org.jboss.arquillian.spi.event.container.AfterDeploy;
import org.jboss.arquillian.spi.event.container.BeforeDeploy;
import org.jboss.arquillian.spi.event.container.ContainerEvent;
import org.jboss.arquillian.spi.event.suite.ClassEvent;
import org.jboss.arquillian.spi.event.suite.EventHandler;
import org.jboss.shrinkwrap.api.Archive;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.spec.JavaArchive;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.runners.MockitoJUnitRunner;
import org.mockito.verification.VerificationMode;

@RunWith(value=MockitoJUnitRunner.class)
public class ContainerDeployerTestCase {
    @Mock
    private ServiceLoader serviceLoader;
    @Mock
    private DeployableContainer container;
    @Mock
    private ContainerMethodExecutor executor;
    @Mock
    private EventHandler<ContainerEvent> eventHandler;

    @Test(expected=IllegalStateException.class)
    public void shouldThrowIllegalStateOnMissingDeployableContainer() throws Exception {
        ClassContext context = new ClassContext(new SuiteContext(this.serviceLoader));
        ContainerDeployer handler = new ContainerDeployer();
        handler.callback((Context)context, new ClassEvent(this.getClass()));
    }

    @Test(expected=IllegalStateException.class)
    public void shouldThrowIllegalStateOnMissingArchive() throws Exception {
        ClassContext context = new ClassContext(new SuiteContext(this.serviceLoader));
        context.add(DeployableContainer.class, (Object)this.container);
        ContainerDeployer handler = new ContainerDeployer();
        handler.callback((Context)context, new ClassEvent(this.getClass()));
    }

    @Test
    public void shouldExportContainerMethodExecutorAndFireEvents() throws Exception {
        Archive deployment = (Archive)ShrinkWrap.create((String)"test.jar", JavaArchive.class);
        ClassContext context = new ClassContext(new SuiteContext(this.serviceLoader));
        context.add(DeployableContainer.class, (Object)this.container);
        context.add(Archive.class, (Object)deployment);
        context.register(BeforeDeploy.class, this.eventHandler);
        context.register(AfterDeploy.class, this.eventHandler);
        Mockito.when((Object)this.container.deploy((Context)context, deployment)).thenReturn((Object)this.executor);
        ContainerDeployer handler = new ContainerDeployer();
        handler.callback((Context)context, new ClassEvent(this.getClass()));
        ((DeployableContainer)Mockito.verify((Object)this.container)).deploy((Context)context, deployment);
        Assert.assertNotNull((String)("Should have exported " + ContainerMethodExecutor.class.getSimpleName()), (Object)context.get(ContainerMethodExecutor.class));
        ((EventHandler)Mockito.verify(this.eventHandler, (VerificationMode)Mockito.times((int)2))).callback((Context)Mockito.any(SuiteContext.class), Mockito.any(ContainerEvent.class));
    }
}

