/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.arquillian.impl;

import org.jboss.arquillian.impl.DynamicServiceLoader;
import org.jboss.arquillian.impl.EventTestRunnerAdaptor;
import org.jboss.arquillian.impl.Validate;
import org.jboss.arquillian.impl.XmlConfigurationBuilder;
import org.jboss.arquillian.impl.context.ClientProfileBuilder;
import org.jboss.arquillian.impl.context.ContainerProfileBuilder;
import org.jboss.arquillian.impl.context.ContextLifecycleManager;
import org.jboss.arquillian.impl.context.ProfileBuilder;
import org.jboss.arquillian.impl.context.StandaloneProfileBuilder;
import org.jboss.arquillian.spi.Configuration;
import org.jboss.arquillian.spi.ContainerConfiguration;
import org.jboss.arquillian.spi.ContainerProfile;
import org.jboss.arquillian.spi.TestRunnerAdaptor;

public class DeployableTestBuilder {
    private static ContainerProfile profile = null;

    private DeployableTestBuilder() {
    }

    public static void setProfile(ContainerProfile profile) {
        Validate.notNull(profile, "Profile must be specified");
        DeployableTestBuilder.profile = profile;
    }

    public static ContainerProfile getProfile() {
        return profile;
    }

    public static TestRunnerAdaptor build() {
        return DeployableTestBuilder.build(profile);
    }

    public static TestRunnerAdaptor build(Configuration configuration) {
        ContainerProfile profile = DeployableTestBuilder.profile;
        ContainerConfiguration activeConfiguration = configuration.getActiveContainerConfiguration();
        if (activeConfiguration != null && profile == null) {
            profile = activeConfiguration.getContainerProfile();
        }
        return DeployableTestBuilder.build(profile, configuration);
    }

    public static TestRunnerAdaptor build(ContainerProfile profile) {
        return DeployableTestBuilder.build(profile, new XmlConfigurationBuilder().build());
    }

    public static TestRunnerAdaptor build(ContainerProfile profile, Configuration configuration) {
        ProfileBuilder profileBuilder = null;
        switch (profile) {
            case STANDALONE: {
                profileBuilder = new StandaloneProfileBuilder();
                break;
            }
            case CONTAINER: {
                profileBuilder = new ContainerProfileBuilder();
                break;
            }
            case CLIENT: {
                profileBuilder = new ClientProfileBuilder();
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknon profile " + profile);
            }
        }
        return DeployableTestBuilder.build(profileBuilder, configuration);
    }

    public static TestRunnerAdaptor build(ProfileBuilder profileBuilder, Configuration configuration) {
        DynamicServiceLoader serviceLoader = new DynamicServiceLoader();
        ContextLifecycleManager eventManager = new ContextLifecycleManager(configuration, profileBuilder, serviceLoader);
        return new EventTestRunnerAdaptor(eventManager);
    }
}

