/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.arquillian.impl;

import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import org.jboss.arquillian.api.Deployment;
import org.jboss.arquillian.impl.Validate;
import org.jboss.arquillian.spi.ApplicationArchiveGenerator;
import org.jboss.shrinkwrap.api.Archive;
import org.jboss.shrinkwrap.api.container.ClassContainer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DeploymentAnnotationArchiveGenerator
implements ApplicationArchiveGenerator {
    public Archive<?> generateApplicationArchive(Class<?> testCase) {
        Validate.notNull(testCase, "TestCase must be specified");
        Method deploymentMethod = DeploymentAnnotationArchiveGenerator.findDeploymentMethod(testCase);
        if (deploymentMethod == null) {
            throw new IllegalArgumentException("No method annotated with " + Deployment.class.getName() + " found");
        }
        if (!Modifier.isStatic(deploymentMethod.getModifiers())) {
            throw new IllegalArgumentException("Method annotated with " + Deployment.class.getName() + " is not static");
        }
        if (!Archive.class.isAssignableFrom(deploymentMethod.getReturnType())) {
            throw new IllegalArgumentException("Method annotated with " + Deployment.class.getName() + " must have return type " + Archive.class.getName());
        }
        try {
            Archive archive = (Archive)deploymentMethod.invoke(null, new Object[0]);
            try {
                if (ClassContainer.class.isInstance(archive)) {
                    ClassContainer classContainer = (ClassContainer)ClassContainer.class.cast(archive);
                    classContainer.addClass(testCase);
                }
            }
            catch (UnsupportedOperationException e) {
                // empty catch block
            }
            return archive;
        }
        catch (Exception e) {
            throw new RuntimeException("Could not get Deployment", e);
        }
    }

    private static Method findDeploymentMethod(Class<?> testCase) {
        Method[] methods;
        for (Method method : methods = testCase.getMethods()) {
            if (!method.isAnnotationPresent(Deployment.class)) continue;
            return method;
        }
        return null;
    }
}

