/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.arquillian.impl;

import java.lang.reflect.Method;
import java.util.Stack;
import org.jboss.arquillian.impl.Validate;
import org.jboss.arquillian.impl.context.ClassContext;
import org.jboss.arquillian.impl.context.ContextLifecycleManager;
import org.jboss.arquillian.impl.context.SuiteContext;
import org.jboss.arquillian.impl.context.TestContext;
import org.jboss.arquillian.spi.Context;
import org.jboss.arquillian.spi.TestMethodExecutor;
import org.jboss.arquillian.spi.TestResult;
import org.jboss.arquillian.spi.TestRunnerAdaptor;
import org.jboss.arquillian.spi.event.Event;
import org.jboss.arquillian.spi.event.suite.After;
import org.jboss.arquillian.spi.event.suite.AfterClass;
import org.jboss.arquillian.spi.event.suite.AfterSuite;
import org.jboss.arquillian.spi.event.suite.Before;
import org.jboss.arquillian.spi.event.suite.BeforeClass;
import org.jboss.arquillian.spi.event.suite.BeforeSuite;
import org.jboss.arquillian.spi.event.suite.Test;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EventTestRunnerAdaptor
implements TestRunnerAdaptor {
    private ContextLifecycleManager contextLifecycle;
    private Stack<Context> activeContext = new Stack();

    public EventTestRunnerAdaptor(ContextLifecycleManager contextLifecycle) {
        Validate.notNull(contextLifecycle, "ContextLifecycle must be specified");
        this.contextLifecycle = contextLifecycle;
    }

    public Context getActiveContext() {
        return this.activeContext.peek();
    }

    public void beforeSuite() throws Exception {
        SuiteContext suiteContext = this.contextLifecycle.createRestoreSuiteContext();
        suiteContext.fire((Event)new BeforeSuite());
        this.activeContext.push(suiteContext);
    }

    public void afterSuite() throws Exception {
        this.contextLifecycle.createRestoreSuiteContext().fire((Event)new AfterSuite());
        this.activeContext.pop();
        this.contextLifecycle.destroySuiteContext();
    }

    public void beforeClass(Class<?> testClass) throws Exception {
        Validate.notNull(testClass, "TestClass must be specified");
        ClassContext classContext = this.contextLifecycle.createRestoreClassContext(testClass);
        classContext.fire((Event)new BeforeClass(testClass));
        this.activeContext.push(classContext);
    }

    public void afterClass(Class<?> testClass) throws Exception {
        Validate.notNull(testClass, "TestClass must be specified");
        this.contextLifecycle.createRestoreClassContext(testClass).fire((Event)new AfterClass(testClass));
        this.activeContext.pop();
        this.contextLifecycle.destroyClassContext(testClass);
    }

    public void before(Object testInstance, Method testMethod) throws Exception {
        Validate.notNull(testInstance, "TestInstance must be specified");
        Validate.notNull(testMethod, "TestMethod must be specified");
        TestContext testContext = this.contextLifecycle.createRestoreTestContext(testInstance);
        testContext.fire((Event)new Before(testInstance, testMethod));
        this.activeContext.push(testContext);
    }

    public void after(Object testInstance, Method testMethod) throws Exception {
        Validate.notNull(testInstance, "TestInstance must be specified");
        Validate.notNull(testMethod, "TestMethod must be specified");
        this.contextLifecycle.createRestoreTestContext(testInstance).fire((Event)new After(testInstance, testMethod));
        this.activeContext.pop();
        this.contextLifecycle.destroyTestContext(testInstance);
    }

    public TestResult test(TestMethodExecutor testMethodExecutor) throws Exception {
        Validate.notNull(testMethodExecutor, "TestMethodExecutor must be specified");
        Test test = new Test(testMethodExecutor);
        TestContext context = this.contextLifecycle.createRestoreTestContext(testMethodExecutor.getInstance());
        context.fire((Event)test);
        return context.get(TestResult.class);
    }
}

